/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.test;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.common.services.shared.test.TestRunnerService;
import org.guvnor.common.services.shared.test.TestService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class TestRunnerServiceImpl
implements TestRunnerService {
    private Event<TestResultMessage> defaultTestResultMessageEvent;
    private Instance<TestService> testServices;

    public TestRunnerServiceImpl() {
    }

    @Inject
    public TestRunnerServiceImpl(@Any Instance<TestService> testServices, Event<TestResultMessage> defaultTestResultMessageEvent) {
        this.testServices = testServices;
        this.defaultTestResultMessageEvent = defaultTestResultMessageEvent;
    }

    public void runAllTests(String identifier, Path path) {
        this.runAllTests(identifier, path, this.defaultTestResultMessageEvent);
    }

    public void runAllTests(String identifier, Path path, Event<TestResultMessage> customTestResultEvent) {
        TestRunEventCollection testResultEvent = new TestRunEventCollection();
        for (TestService testService : this.testServices) {
            testService.runAllTests(identifier, path, (Event)testResultEvent);
        }
        customTestResultEvent.fire((Object)new TestResultMessage(identifier, testResultEvent.getRunCountSum(), testResultEvent.getRuntimeSum(), testResultEvent.getFailures()));
    }

    private class TestRunEventCollection
    implements Event<TestResultMessage> {
        private List<TestResultMessage> resultMessages = new ArrayList<TestResultMessage>();

        private TestRunEventCollection() {
        }

        public void fire(TestResultMessage testResultMessage) {
            this.resultMessages.add(testResultMessage);
        }

        public Event<TestResultMessage> select(Annotation ... annotations) {
            return null;
        }

        public <U extends TestResultMessage> Event<U> select(Class<U> aClass, Annotation ... annotations) {
            return null;
        }

        public int getRunCountSum() {
            int result = 0;
            for (TestResultMessage message : this.resultMessages) {
                result += message.getRunCount();
            }
            return result;
        }

        public long getRuntimeSum() {
            long result = 0L;
            for (TestResultMessage message : this.resultMessages) {
                result += message.getRunTime();
            }
            return result;
        }

        public List<Failure> getFailures() {
            ArrayList<Failure> result = new ArrayList<Failure>();
            for (TestResultMessage message : this.resultMessages) {
                result.addAll(message.getFailures());
            }
            return result;
        }
    }
}

