/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.attributes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.attributes.Attribute;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.code.StackEntry;
import org.jboss.classfilewriter.code.StackEntryType;
import org.jboss.classfilewriter.code.StackFrame;
import org.jboss.classfilewriter.code.StackFrameType;
import org.jboss.classfilewriter.constpool.ConstPool;
import org.jboss.classfilewriter.util.ByteArrayDataOutputStream;
import org.jboss.classfilewriter.util.LazySize;

public class StackMapTableAttribute
extends Attribute {
    private static final int FULL_FRAME = 255;
    private static final int SAME_FRAME_EXTENDED = 251;
    public static final String NAME = "StackMapTable";
    private final ClassMethod method;

    public StackMapTableAttribute(ClassMethod classMethod, ConstPool constPool) {
        super(NAME, constPool);
        this.method = classMethod;
    }

    @Override
    public void writeData(ByteArrayDataOutputStream stream) throws IOException {
        CodeAttribute ca = this.method.getCodeAttribute();
        LazySize size = stream.writeSize();
        stream.writeShort(ca.getStackFrames().size());
        int lastPos = -1;
        for (Map.Entry<Integer, StackFrame> entry : this.method.getCodeAttribute().getStackFrames().entrySet()) {
            int offset = entry.getKey() - lastPos - 1;
            lastPos = entry.getKey();
            StackFrame frame = entry.getValue();
            if (frame.getType() == StackFrameType.SAME_FRAME || frame.getType() == StackFrameType.SAME_FRAME_EXTENDED) {
                this.writeSameFrame(stream, offset, lastPos, frame);
                continue;
            }
            if (frame.getType() == StackFrameType.SAME_LOCALS_1_STACK && offset < 63) {
                this.writeSameLocals1Stack(stream, offset, lastPos, frame);
                continue;
            }
            this.writeFullFrame(stream, offset, lastPos, entry.getValue());
        }
        size.markEnd();
    }

    private void writeSameLocals1Stack(DataOutputStream dstream, int offset, int lastPos, StackFrame frame) throws IOException {
        dstream.writeByte(offset + 64);
        frame.getStackState().getContents().get(0).write(dstream);
    }

    private void writeSameFrame(DataOutputStream dstream, int offset, int lastPos, StackFrame frame) throws IOException {
        if (offset > 63) {
            dstream.writeByte(251);
            dstream.writeShort(offset);
        } else {
            dstream.writeByte(offset);
        }
    }

    private void writeFullFrame(DataOutputStream dstream, int offset, int position, StackFrame value) throws IOException {
        dstream.writeByte(255);
        dstream.writeShort(offset);
        ArrayList<StackEntry> realLocalVars = new ArrayList<StackEntry>(value.getLocalVariableState().getContents().size());
        for (StackEntry i : value.getLocalVariableState().getContents()) {
            if (i.getType() == StackEntryType.TOP) continue;
            realLocalVars.add(i);
        }
        dstream.writeShort(realLocalVars.size());
        for (StackEntry i : realLocalVars) {
            i.write(dstream);
        }
        ArrayList<StackEntry> realStack = new ArrayList<StackEntry>(value.getStackState().getContents().size());
        for (StackEntry i : value.getStackState().getContents()) {
            if (i.getType() == StackEntryType.TOP) continue;
            realStack.add(i);
        }
        dstream.writeShort(realStack.size());
        for (StackEntry i : realStack) {
            i.write(dstream);
        }
    }
}

