/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.repositories.git.GitRepositoryBuilder;
import org.guvnor.structure.backend.repositories.git.hooks.PostCommitNotificationService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryExternalUpdateEvent;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.repositories.RepositoryFactoryHelper;
import org.kie.soup.commons.validation.Preconditions;
import org.uberfire.io.IOService;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
public class GitRepositoryFactoryHelper
implements RepositoryFactoryHelper {
    private IOService indexedIOService;
    private IOService notIndexedIOService;
    private SpacesAPI spacesAPI;
    private Event<RepositoryExternalUpdateEvent> repositoryExternalUpdate;
    private PostCommitNotificationService postCommitNotificationService;
    @Inject
    private PasswordService secureService;

    public GitRepositoryFactoryHelper() {
    }

    @Inject
    public GitRepositoryFactoryHelper(@Named(value="ioStrategy") IOService indexedIOService, @Named(value="configIO") IOService notIndexedIOService, SpacesAPI spacesAPI, Event<RepositoryExternalUpdateEvent> repositoryExternalUpdate, PostCommitNotificationService postCommitNotificationService) {
        this.indexedIOService = indexedIOService;
        this.notIndexedIOService = notIndexedIOService;
        this.spacesAPI = spacesAPI;
        this.repositoryExternalUpdate = repositoryExternalUpdate;
        this.postCommitNotificationService = postCommitNotificationService;
    }

    public boolean accept(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        return GitRepository.SCHEME.toString().equals(schemeConfigItem.getValue());
    }

    public Repository newRepository(ConfigGroup repoConfig) {
        this.validate(repoConfig);
        ConfigItem sValue = repoConfig.getConfigItem("avoid_index");
        if (sValue != null && Boolean.valueOf((String)sValue.getValue()).booleanValue()) {
            return new GitRepositoryBuilder(this.notIndexedIOService, this.secureService, this.spacesAPI, this.repositoryExternalUpdate, this.postCommitNotificationService).build(repoConfig);
        }
        return new GitRepositoryBuilder(this.indexedIOService, this.secureService, this.spacesAPI, this.repositoryExternalUpdate, this.postCommitNotificationService).build(repoConfig);
    }

    private void validate(ConfigGroup repoConfig) {
        Preconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        Preconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
    }
}

