/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerUtils;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.FEELImpl;
import org.kie.dmn.feel.runtime.events.DecisionTableRulesMatchedEvent;
import org.kie.dmn.feel.runtime.events.DecisionTableRulesSelectedEvent;
import org.kie.dmn.feel.runtime.functions.DTInvokerFunction;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNDTExpressionEvaluator
implements DMNExpressionEvaluator {
    private static Logger logger = LoggerFactory.getLogger(DMNDTExpressionEvaluator.class);
    private final DMNNode node;
    private DTInvokerFunction dt;
    private FEELImpl feel;

    public DMNDTExpressionEvaluator(DMNNode node, FEEL feel, DTInvokerFunction dt) {
        this.node = node;
        this.dt = dt;
        this.feel = (FEELImpl)feel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager dmrem, DMNResult dmnr) {
        EvaluatorResultImpl evaluatorResultImpl;
        ArrayList<FEELEvent> events = new ArrayList<FEELEvent>();
        DMNResultImpl result = (DMNResultImpl)dmnr;
        EventResults r = null;
        try {
            DMNRuntimeEventManagerUtils.fireBeforeEvaluateDecisionTable(dmrem, this.node.getName(), this.dt.getName(), result);
            List paramNames = (List)this.dt.getParameterNames().get(0);
            Object[] params = new Object[paramNames.size()];
            FEELEventListener[] fEELEventListenerArray = new FEELEventListener[1];
            fEELEventListenerArray[0] = events::add;
            EvaluationContextImpl ctx = this.feel.newEvaluationContext(Arrays.asList(fEELEventListenerArray), Collections.emptyMap());
            ctx.setPerformRuntimeTypeCheck(((DMNRuntimeImpl)dmrem.getRuntime()).performRuntimeTypeCheck(result.getModel()));
            ctx.enterFrame();
            for (Map.Entry entry : result.getContext().getAll().entrySet()) {
                ctx.setValue((String)entry.getKey(), entry.getValue());
            }
            for (int i = 0; i < params.length; ++i) {
                FEELEventListener[] fEELEventListenerArray2 = new FEELEventListener[1];
                fEELEventListenerArray2[0] = events::add;
                EvaluationContextImpl evalCtx = this.feel.newEvaluationContext(Arrays.asList(fEELEventListenerArray2), Collections.emptyMap());
                evalCtx.setValues(result.getContext().getAll());
                params[i] = this.feel.evaluate((CompiledExpression)this.dt.getDecisionTable().getCompiledParameterNames().get(i), (EvaluationContext)evalCtx);
                ctx.setValue((String)paramNames.get(i), params[i]);
            }
            Object dtr = this.dt.invoke((EvaluationContext)ctx, params).cata(e -> {
                events.add((FEELEvent)e);
                return null;
            }, Function.identity());
            ctx.exitFrame();
            r = DMNDTExpressionEvaluator.processEvents(events, dmrem, result, this.node);
            evaluatorResultImpl = new EvaluatorResultImpl(dtr, r.hasErrors ? EvaluatorResult.ResultType.FAILURE : EvaluatorResult.ResultType.SUCCESS);
        }
        catch (Throwable throwable) {
            DMNRuntimeEventManagerUtils.fireAfterEvaluateDecisionTable(dmrem, this.node.getName(), this.dt.getName(), result, r != null ? r.matchedRules : null, r != null ? r.fired : null);
            throw throwable;
        }
        DMNRuntimeEventManagerUtils.fireAfterEvaluateDecisionTable(dmrem, this.node.getName(), this.dt.getName(), result, r != null ? r.matchedRules : null, r != null ? r.fired : null);
        return evaluatorResultImpl;
    }

    public static EventResults processEvents(List<FEELEvent> events, DMNRuntimeEventManager eventManager, DMNResultImpl result, DMNNode node) {
        EventResults r = new EventResults();
        for (FEELEvent e : events) {
            if (e instanceof DecisionTableRulesMatchedEvent) {
                r.matchedRules = ((DecisionTableRulesMatchedEvent)e).getMatches();
                continue;
            }
            if (e instanceof DecisionTableRulesSelectedEvent) {
                r.fired = ((DecisionTableRulesSelectedEvent)e).getFired();
                continue;
            }
            if (e.getSeverity() == FEELEvent.Severity.ERROR) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)node).getSource(), result, null, e, Msg.FEEL_ERROR, e.getMessage());
                r.hasErrors = true;
                continue;
            }
            if (e.getSeverity() != FEELEvent.Severity.WARN) continue;
            MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)((DMNBaseNode)node).getSource(), result, null, e, Msg.FEEL_WARN, e.getMessage());
        }
        events.clear();
        return r;
    }

    public static class EventResults {
        public boolean hasErrors = false;
        public List<Integer> matchedRules;
        public List<Integer> fired;
    }
}

