/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.antlr.v4.runtime.CommonToken;
import org.drools.javaparser.ast.CompilationUnit;
import org.drools.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.codegen.feel11.ProcessedUnaryTest;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.FEELProfile;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.lang.impl.FEELImpl;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;
import org.kie.dmn.feel.runtime.events.UnknownVariableErrorEvent;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNFEELHelper {
    private static final Logger logger = LoggerFactory.getLogger(DMNFEELHelper.class);
    private final ClassLoader classLoader;
    private final FEEL feel;
    private final FEELEventsListenerImpl listener;
    private final List<FEELProfile> feelProfiles = new ArrayList<FEELProfile>();

    public DMNFEELHelper(List<FEELProfile> feelProfiles) {
        this(ClassLoaderUtil.findDefaultClassLoader(), feelProfiles);
    }

    public DMNFEELHelper(ClassLoader classLoader, List<FEELProfile> feelProfiles) {
        this.classLoader = classLoader;
        this.feelProfiles.addAll(feelProfiles);
        this.listener = new FEELEventsListenerImpl();
        this.feel = this.createFEELInstance();
    }

    private FEEL createFEELInstance() {
        FEEL feel = FEEL.newInstance((ClassLoader)this.classLoader, this.feelProfiles);
        feel.addListener((FEELEventListener)this.listener);
        return feel;
    }

    public FEEL newFEELInstance() {
        return FEEL.newInstance((ClassLoader)this.classLoader, this.feelProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean valueMatchesInUnaryTests(List<UnaryTest> unaryTests, Object value, DMNContext dmnContext) {
        FEELEventListenersManager manager = new FEELEventListenersManager();
        FEELEventsListenerImpl listener = new FEELEventsListenerImpl();
        manager.addListener((FEELEventListener)listener);
        EvaluationContextImpl ctx = new EvaluationContextImpl(ClassLoaderUtil.findDefaultClassLoader(), manager);
        try {
            ctx.enterFrame();
            if (dmnContext != null) {
                for (Map.Entry entry : dmnContext.getAll().entrySet()) {
                    ctx.setValue((String)entry.getKey(), entry.getValue());
                }
            }
            for (UnaryTest unaryTest : unaryTests) {
                try {
                    Boolean applyT = (Boolean)unaryTest.apply((Object)ctx, value);
                    if (applyT == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!applyT.booleanValue()) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable e) {
                    StringBuilder message = new StringBuilder();
                    for (FEELEvent feelEvent : listener.getFeelEvents()) {
                        message.append(feelEvent.getMessage());
                        message.append("\n");
                    }
                    throw new RuntimeException(message.toString(), e);
                    return false;
                }
            }
        }
        finally {
            ctx.exitFrame();
        }
    }

    public CompiledExpression compileFeelExpression(DMNCompilerContext ctx, String expression, DMNModelImpl model, DMNElement element, Msg.Message errorMsg, Object ... msgParams) {
        CompilerContext feelctx = this.feel.newCompilerContext();
        for (Map.Entry<String, DMNType> entry : ctx.getVariables().entrySet()) {
            feelctx.addInputVariableType(entry.getKey(), ((BaseDMNTypeImpl)entry.getValue()).getFeelType());
        }
        CompiledExpression ce = this.feel.compile(expression, feelctx);
        this.processEvents(model, element, errorMsg, msgParams);
        return ce;
    }

    public FEELFunction evaluateFunctionDef(DMNCompilerContext ctx, String expression, DMNModelImpl model, DMNElement element, Msg.Message errorMsg, Object ... msgParams) {
        FEELFunction function = null;
        try {
            function = (FEELFunction)this.feel.evaluate(expression);
        }
        catch (Throwable t) {
            logger.error("Error evaluating function definition. Error will be reported in the model.", t);
        }
        this.processEvents(model, element, errorMsg, msgParams);
        return function;
    }

    public FEELFunction evaluateFunctionDef(DMNCompilerContext ctx, CompiledExpression expression, DMNModelImpl model, DMNElement element, Msg.Message errorMsg, Object ... msgParams) {
        FEELFunction function = null;
        try {
            function = (FEELFunction)this.feel.evaluate(expression, Collections.emptyMap());
        }
        catch (Throwable t) {
            logger.error("Error evaluating function definition. Error will be reported in the model.", t);
        }
        this.processEvents(model, element, errorMsg, msgParams);
        return function;
    }

    public List<UnaryTest> evaluateUnaryTests(DMNCompilerContext ctx, String unaryTests, DMNModelImpl model, DMNElement element, Msg.Message errorMsg, Object ... msgParams) {
        List result = Collections.emptyList();
        try {
            HashMap<String, Type> variableTypes = new HashMap<String, Type>();
            for (Map.Entry<String, DMNType> entry : ctx.getVariables().entrySet()) {
                variableTypes.put(entry.getKey(), ((BaseDMNTypeImpl)entry.getValue()).getFeelType());
            }
            result = this.feel.evaluateUnaryTests(unaryTests, variableTypes);
        }
        catch (Throwable t) {
            logger.error("Error evaluating unary tests. Error will be reported in the model.", t);
        }
        this.processEvents(model, element, errorMsg, msgParams);
        return result;
    }

    public void processEvents(DMNModelImpl model, DMNElement element, Msg.Message msg, Object ... msgParams) {
        Queue<FEELEvent> feelEvents = this.listener.getFeelEvents();
        while (!feelEvents.isEmpty()) {
            FEELEvent event = feelEvents.remove();
            if (this.isDuplicateEvent(model, msg, element) || !(event instanceof SyntaxErrorEvent) && event.getSeverity() != FEELEvent.Severity.ERROR) continue;
            if (msg instanceof Msg.Message2) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)element, model, null, event, (Msg.Message2)msg, msgParams[0], msgParams[1]);
                continue;
            }
            if (msg instanceof Msg.Message3) {
                Object message3 = null;
                message3 = msgParams.length == 3 ? msgParams[2] : event.getMessage();
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)element, model, null, event, (Msg.Message3)msg, msgParams[0], msgParams[1], message3);
                continue;
            }
            if (!(msg instanceof Msg.Message4)) continue;
            String message = null;
            message = event.getOffendingSymbol() == null ? "" : (event instanceof UnknownVariableErrorEvent ? event.getMessage() : (event.getOffendingSymbol() instanceof CommonToken ? "syntax error near '" + ((CommonToken)event.getOffendingSymbol()).getText() + "'" : "syntax error near '" + event.getOffendingSymbol() + "'"));
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)element, model, null, event, (Msg.Message4)msg, msgParams[0], msgParams[1], msgParams[2], message);
        }
    }

    private boolean isDuplicateEvent(DMNModelImpl model, Msg.Message error, DMNElement element) {
        return model.getMessages().stream().anyMatch(msg -> msg.getMessageType() == error.getType() && (msg.getSourceId() == element.getId() || msg.getSourceId() != null && element.getId() != null && msg.getSourceId().equals(element.getId())));
    }

    public ClassOrInterfaceDeclaration generateUnaryTestsSource(String unaryTests, DMNCompilerContext ctx, Type inputColumnType) {
        CompilerContext compilerContext = ctx.toCompilerContext().addInputVariableType("?", inputColumnType);
        ProcessedUnaryTest compiledUnaryTest = ((FEELImpl)this.feel).compileUnaryTests(unaryTests, compilerContext);
        CompilationUnit compilationUnit = compiledUnaryTest.getSourceCode().clone();
        return (ClassOrInterfaceDeclaration)compilationUnit.getType(0).asClassOrInterfaceDeclaration().setStatic(true);
    }

    public EvaluationContextImpl newEvaluationContext(Collection<FEELEventListener> listeners, Map<String, Object> inputVariables) {
        return ((FEELImpl)this.feel).newEvaluationContext(listeners, inputVariables);
    }

    public List<UnaryTest> evaluateUnaryTests(String expression, Map<String, Type> variableTypes) {
        return this.feel.evaluateUnaryTests(expression, variableTypes);
    }

    public CompilerContext newCompilerContext() {
        return this.feel.newCompilerContext();
    }

    public CompiledExpression compile(DMNModelImpl model, DMNElement element, Msg.Message msg, String dtableName, String expr, CompilerContext feelctx, int index) {
        CompiledExpression compiled = this.feel.compile(expr, feelctx);
        this.processEvents(model, element, msg, expr, dtableName, index);
        return compiled;
    }

    public ClassOrInterfaceDeclaration generateFeelExpressionSource(String input, CompilerContext compilerContext1) {
        CompilationUnit compilationUnit = ((FEELImpl)this.feel).generateExpressionSource(input, compilerContext1);
        return (ClassOrInterfaceDeclaration)compilationUnit.getType(0).asClassOrInterfaceDeclaration().setStatic(true);
    }

    public static class FEELEventsListenerImpl
    implements FEELEventListener {
        private final Queue<FEELEvent> feelEvents = new LinkedList<FEELEvent>();

        public void onEvent(FEELEvent event) {
            this.feelEvents.add(event);
        }

        public Queue<FEELEvent> getFeelEvents() {
            return this.feelEvents;
        }
    }
}

