/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import java.util.EnumSet;
import java.util.List;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.ArrayCreationLevel;
import org.drools.javaparser.ast.CompilationUnit;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.BodyDeclaration;
import org.drools.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.drools.javaparser.ast.body.ConstructorDeclaration;
import org.drools.javaparser.ast.body.FieldDeclaration;
import org.drools.javaparser.ast.body.VariableDeclarator;
import org.drools.javaparser.ast.expr.AnnotationExpr;
import org.drools.javaparser.ast.expr.ArrayCreationExpr;
import org.drools.javaparser.ast.expr.ArrayInitializerExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.ObjectCreationExpr;
import org.drools.javaparser.ast.type.ArrayType;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.Type;

public class JavaParserSourceGenerator {
    private ClassOrInterfaceDeclaration firstClass;
    private CompilationUnit compilationUnit;
    public static EnumSet<Modifier> PUBLIC_STATIC_FINAL = EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);

    public JavaParserSourceGenerator(String className, String namespace, String packageName) {
        this.compilationUnit = JavaParser.parse((String)("public class " + className + namespace + "{ }"));
        this.compilationUnit.setPackageDeclaration(packageName);
        this.firstClass = (ClassOrInterfaceDeclaration)this.compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new RuntimeException("Cannot find Class"));
    }

    public void addImports(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.compilationUnit.addImport(clazz);
        }
    }

    public void addInnerClassWithName(ClassOrInterfaceDeclaration feelExpressionSource, String name) {
        this.renameFeelExpressionClass(name, feelExpressionSource);
        this.firstClass.addMember((BodyDeclaration)feelExpressionSource);
    }

    public void addMember(FieldDeclaration feelExpressionSource) {
        this.firstClass.addMember((BodyDeclaration)feelExpressionSource);
    }

    public void addField(String testClass, Class<?> type, String instanceName) {
        ClassOrInterfaceType innerClassType = this.getType(testClass);
        ObjectCreationExpr newInstanceOfInnerClass = new ObjectCreationExpr(null, innerClassType, NodeList.nodeList((Node[])new Expression[0]));
        VariableDeclarator variableDeclarator = new VariableDeclarator((Type)this.getType(type), instanceName, (Expression)newInstanceOfInnerClass);
        this.firstClass.addMember((BodyDeclaration)new FieldDeclaration(PUBLIC_STATIC_FINAL, variableDeclarator));
    }

    public void addTwoDimensionalArray(List<List<String>> initializers, String arrayName, Class<?> type) {
        NodeList arrayCreationLevels = NodeList.nodeList((Node[])new ArrayCreationLevel[]{new ArrayCreationLevel(), new ArrayCreationLevel()});
        NodeList arrayInitializers = NodeList.nodeList((Node[])new Expression[0]);
        for (List<String> innerInitializer : initializers) {
            NodeList arrayInitializerInner = NodeList.nodeList((Node[])new Expression[0]);
            for (String instanceName : innerInitializer) {
                arrayInitializerInner.add((Node)new NameExpr(instanceName));
            }
            arrayInitializers.add((Node)new ArrayInitializerExpr(arrayInitializerInner));
        }
        ArrayInitializerExpr initializerMainArray = new ArrayInitializerExpr(arrayInitializers);
        ArrayCreationExpr arrayCreationExpr = new ArrayCreationExpr((Type)this.getType(type), arrayCreationLevels, initializerMainArray);
        VariableDeclarator variable = new VariableDeclarator((Type)new ArrayType((Type)new ArrayType((Type)this.getType(type), new AnnotationExpr[0]), new AnnotationExpr[0]), arrayName, (Expression)arrayCreationExpr);
        this.addMember(new FieldDeclaration(PUBLIC_STATIC_FINAL, variable));
    }

    private ClassOrInterfaceType getType(String canonicalName) {
        return JavaParser.parseClassOrInterfaceType((String)canonicalName);
    }

    private ClassOrInterfaceType getType(Class<?> clazz) {
        return JavaParser.parseClassOrInterfaceType((String)clazz.getCanonicalName());
    }

    private void renameFeelExpressionClass(String testClass, ClassOrInterfaceDeclaration classOrInterfaceDeclaration) {
        String finalTestClass = testClass;
        classOrInterfaceDeclaration.setName(finalTestClass);
        classOrInterfaceDeclaration.findAll(ConstructorDeclaration.class).forEach(n -> n.replace((Node)new ConstructorDeclaration(finalTestClass)));
    }

    public String getSource() {
        return this.compilationUnit.toString();
    }
}

