/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.fluent;

import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.internal.command.RegistryContext;

public class ExecuteDMNCommand
implements ExecutableCommand<DMNResult> {
    public DMNResult execute(Context context) {
        RegistryContext registryContext = (RegistryContext)context;
        DMNModel activeModel = (DMNModel)registryContext.lookup(DMNModel.class);
        DMNRuntime dmnRuntime = (DMNRuntime)registryContext.lookup(DMNRuntime.class);
        DMNContext dmnContext = (DMNContext)registryContext.lookup(DMNContext.class);
        if (activeModel == null) {
            throw new IllegalStateException("No DMN active model defined");
        }
        if (dmnRuntime == null) {
            throw new IllegalStateException("No DMNRuntime available");
        }
        if (dmnContext == null) {
            dmnContext = dmnRuntime.newContext();
        }
        DMNResult dmnResult = dmnRuntime.evaluateAll(activeModel, dmnContext);
        registryContext.register(DMNResult.class, (Object)dmnResult);
        registryContext.register(DMNContext.class, (Object)dmnRuntime.newContext());
        return dmnResult;
    }
}

