/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;

@Dependent
@Templated
public class RenamePopUpView
implements RenamePopUpPresenter.View {
    @DataField(value="modal-view")
    private HTMLDivElement view;
    @DataField(value="modal-body")
    private HTMLDivElement body;
    @DataField(value="modal-footer")
    private HTMLDivElement footer;
    @DataField(value="cancel")
    private HTMLButtonElement cancel;
    @DataField(value="rename")
    private HTMLButtonElement rename;
    @DataField(value="saveAndRename")
    private HTMLButtonElement saveAndRename;
    @DataField(value="newNameTextBox")
    private HTMLInputElement newNameTextBox;
    @DataField(value="error")
    private HTMLDivElement error;
    @DataField(value="errorMessage")
    private HTMLElement errorMessage;
    private TranslationService translationService;
    private RenamePopUpPresenter presenter;
    private BaseModal modal;
    private String originalFileName;

    @Inject
    public RenamePopUpView(HTMLDivElement body, HTMLDivElement view, HTMLButtonElement cancel, HTMLButtonElement rename, HTMLButtonElement saveAndRename, HTMLDivElement footer, HTMLInputElement newNameTextBox, HTMLDivElement error, @Named(value="span") HTMLElement errorMessage, TranslationService translationService) {
        this.body = body;
        this.view = view;
        this.cancel = cancel;
        this.footer = footer;
        this.rename = rename;
        this.saveAndRename = saveAndRename;
        this.newNameTextBox = newNameTextBox;
        this.error = error;
        this.errorMessage = errorMessage;
        this.translationService = translationService;
    }

    public void init(RenamePopUpPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void show() {
        this.setup();
        this.modal.show();
    }

    private void setup() {
        this.modalSetup();
        this.errorSetup();
        this.setupComment();
        this.newNameTextBoxSetup();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void handleDuplicatedFileName() {
        this.showError(this.translate("RenamePopUpView.FileAlreadyExists", this.newNameTextBox.value));
    }

    @Override
    public void handleInvalidFileName() {
        this.showError(this.translate("RenamePopUpView.InvalidFileName", this.newNameTextBox.value));
    }

    @Override
    public void setOriginalFileName(String fileName) {
        this.originalFileName = fileName;
    }

    @Override
    public void handleRenameNotAllowed() {
        this.showError(this.translate("RenamePopUpView.RenameNotAllowed", new Object[0]));
    }

    @EventHandler(value={"newNameTextBox"})
    public void onNewFileNameChange(KeyUpEvent event) {
        this.disableRenameButtonsIfNewNameIsNotNew();
    }

    @EventHandler(value={"cancel"})
    private void cancelCommand(ClickEvent event) {
        this.presenter.cancel();
    }

    @EventHandler(value={"rename"})
    private void onRename(ClickEvent event) {
        this.presenter.rename(this.newNameTextBox.value);
    }

    @EventHandler(value={"saveAndRename"})
    private void onSaveAndRename(ClickEvent event) {
        this.presenter.saveAndRename(this.newNameTextBox.value);
    }

    @Override
    public void renameAsPrimary() {
        this.addPrimaryClass(this.rename);
        this.removePrimaryClass(this.saveAndRename);
    }

    @Override
    public void saveAndRenameAsPrimary() {
        this.addPrimaryClass(this.saveAndRename);
        this.removePrimaryClass(this.rename);
    }

    @Override
    public void hideSaveAndRename(boolean hidden) {
        this.saveAndRename.hidden = hidden;
    }

    private void modalSetup() {
        this.modal = new CommonModalBuilder().addHeader(this.translate("RenamePopUpView.RenameAsset", new Object[0])).addBody((HTMLElement)this.body).addFooter((HTMLElement)this.footer).build();
    }

    private void addPrimaryClass(HTMLButtonElement buttonElement) {
        buttonElement.classList.add(new String[]{ButtonType.PRIMARY.getCssName()});
    }

    private void removePrimaryClass(HTMLButtonElement buttonElement) {
        buttonElement.classList.remove(new String[]{ButtonType.PRIMARY.getCssName()});
    }

    private String translate(String key, Object ... args) {
        return this.translationService.format(key, args);
    }

    private void newNameTextBoxSetup() {
        this.newNameTextBox.value = this.originalFileName;
        this.disableRenameButtonsIfNewNameIsNotNew();
    }

    private void errorSetup() {
        this.error.hidden = true;
    }

    private void disableRenameButtonsIfNewNameIsNotNew() {
        boolean disabled;
        this.rename.disabled = disabled = this.newNameTextBox.value.equals(this.originalFileName);
        this.saveAndRename.disabled = disabled;
    }

    private void showError(String errorMessage) {
        this.errorMessage.textContent = errorMessage;
        this.error.hidden = false;
    }

    private void setupComment() {
        this.body.appendChild(this.getToggleCommentElement());
    }

    private Node getToggleCommentElement() {
        ToggleCommentPresenter toggleCommentPresenter = this.presenter.getToggleCommentPresenter();
        ToggleCommentPresenter.View view = toggleCommentPresenter.getView();
        return view.getElement();
    }

    public HTMLElement getElement() {
        return this.view;
    }
}

