/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.api.preferences;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.uberfire.preferences.shared.annotations.Property;
import org.uberfire.preferences.shared.annotations.WorkbenchPreference;
import org.uberfire.preferences.shared.bean.BasePreference;
import org.uberfire.spaces.Space;

@WorkbenchPreference(identifier="LibraryInternalPreferences")
public class LibraryInternalPreferences
implements BasePreference<LibraryInternalPreferences> {
    @Property
    boolean projectExplorerExpanded;
    @Property
    String lastOpenedOrganizationalUnit;
    @Property
    Map<String, Map<String, String>> lastOpenedBranchPerRepositoryInSpace;

    public LibraryInternalPreferences defaultValue(LibraryInternalPreferences defaultValue) {
        defaultValue.projectExplorerExpanded = false;
        return defaultValue;
    }

    public boolean isProjectExplorerExpanded() {
        return this.projectExplorerExpanded;
    }

    public void setProjectExplorerExpanded(boolean projectExplorerExpanded) {
        this.projectExplorerExpanded = projectExplorerExpanded;
    }

    public String getLastOpenedOrganizationalUnit() {
        return this.lastOpenedOrganizationalUnit;
    }

    public void setLastOpenedOrganizationalUnit(String lastOpenedOrganizationalUnit) {
        this.lastOpenedOrganizationalUnit = lastOpenedOrganizationalUnit;
    }

    public void setLastBranchOpened(WorkspaceProject project, Branch branch) {
        Space space = project.getSpace();
        Repository repository = project.getRepository();
        if (this.lastOpenedBranchPerRepositoryInSpace == null) {
            this.lastOpenedBranchPerRepositoryInSpace = new HashMap<String, Map<String, String>>();
        }
        Map lastOpenedBranchPerRepository = this.lastOpenedBranchPerRepositoryInSpace.computeIfAbsent(space.getName(), k -> new HashMap());
        lastOpenedBranchPerRepository.put(repository.getAlias(), branch.getName());
    }

    public Optional<Branch> getLastBranchOpened(WorkspaceProject project) {
        Space space = project.getSpace();
        Repository repository = project.getRepository();
        if (this.lastOpenedBranchPerRepositoryInSpace == null) {
            return Optional.empty();
        }
        Map<String, String> lastOpenedBranchPerRepository = this.lastOpenedBranchPerRepositoryInSpace.get(space.getName());
        if (lastOpenedBranchPerRepository == null) {
            return Optional.empty();
        }
        String lastOpenedBranch = lastOpenedBranchPerRepository.get(repository.getAlias());
        if (lastOpenedBranch == null) {
            return Optional.empty();
        }
        return project.getRepository().getBranch(lastOpenedBranch);
    }
}

