/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.processors;

import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractErrorAbsorbingProcessor;
import org.uberfire.annotations.processors.GenerationCompleteCallback;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.ext.preferences.processors.GeneratorContext;
import org.uberfire.ext.preferences.processors.WorkbenchPreferenceGeneratedImplGenerator;

@SupportedAnnotationTypes(value={"org.uberfire.preferences.shared.annotations.WorkbenchPreference"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class WorkbenchPreferenceProcessor
extends AbstractErrorAbsorbingProcessor {
    public static final String WORKBENCH_PREFERENCE = "org.uberfire.preferences.shared.annotations.WorkbenchPreference";
    private GenerationCompleteCallback callback = null;

    public WorkbenchPreferenceProcessor() {
    }

    WorkbenchPreferenceProcessor(GenerationCompleteCallback callback) {
        this();
        this.callback = callback;
        System.out.println("GenerationCompleteCallback has been provided. Generated source code will not be compiled and hence classes will not be available.");
    }

    public boolean processWithExceptions(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws IOException {
        if (roundEnv.processingOver()) {
            return false;
        }
        if (roundEnv.errorRaised()) {
            return false;
        }
        Messager messager = this.processingEnv.getMessager();
        Elements elementUtils = this.processingEnv.getElementUtils();
        for (Element element : roundEnv.getElementsAnnotatedWith(elementUtils.getTypeElement(WORKBENCH_PREFERENCE))) {
            if (element.getKind() != ElementKind.CLASS) continue;
            WorkbenchPreferenceGeneratedImplGenerator beanGenerator = null;
            WorkbenchPreferenceGeneratedImplGenerator portableGenerator = null;
            try {
                beanGenerator = new WorkbenchPreferenceGeneratedImplGenerator(GeneratorContext.BEAN);
                portableGenerator = new WorkbenchPreferenceGeneratedImplGenerator(GeneratorContext.PORTABLE);
            }
            catch (Throwable t) {
                this.rememberInitializationError(t);
            }
            TypeElement classElement = (TypeElement)element;
            PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
            messager.printMessage(Diagnostic.Kind.NOTE, "Discovered class [" + classElement.getSimpleName() + "]");
            String packageName = packageElement.getQualifiedName().toString();
            String className = classElement.getSimpleName() + "";
            this.generate(messager, classElement, packageElement, packageName, className, beanGenerator);
            this.generate(messager, classElement, packageElement, packageName, className, portableGenerator);
        }
        return true;
    }

    private void generate(Messager messager, TypeElement classElement, PackageElement packageElement, String packageName, String className, WorkbenchPreferenceGeneratedImplGenerator generator) throws IOException {
        try {
            messager.printMessage(Diagnostic.Kind.NOTE, "Generating code for [" + className + "]");
            StringBuffer generatedImplCode = generator.generate(packageName, packageElement, className, classElement, this.processingEnv);
            if (this.callback == null) {
                this.writeCode(packageName, generator.getTargetClassName(), generatedImplCode);
            } else {
                this.callback.generationComplete(generatedImplCode.toString());
            }
        }
        catch (GenerationException ge) {
            String msg = ge.getMessage();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, classElement);
        }
    }
}

