/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.ickl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.backend.infinispan.ickl.FieldConverterImpl;
import org.uberfire.ext.metadata.backend.infinispan.ickl.converters.BooleanQueryConverter;
import org.uberfire.ext.metadata.backend.infinispan.ickl.converters.TermQueryConverter;
import org.uberfire.ext.metadata.backend.infinispan.ickl.converters.WildcardQueryConverter;

public class IckleConverter {
    private static final String ORDER_BY = "order by ";
    private static final String WHERE = "where ";
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";
    private Logger logger = LoggerFactory.getLogger(IckleConverter.class);
    private final FieldConverterImpl converterImpl = new FieldConverterImpl();

    public String convert(Query query) {
        if (TermQuery.class.isAssignableFrom(query.getClass())) {
            return new TermQueryConverter((TermQuery)query, this.converterImpl).convert();
        }
        if (WildcardQuery.class.isAssignableFrom(query.getClass())) {
            return new WildcardQueryConverter((WildcardQuery)query, this.converterImpl).convert();
        }
        if (BooleanQuery.class.isAssignableFrom(query.getClass())) {
            return new BooleanQueryConverter((BooleanQuery)query, this).convert();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Converter not found, MatchAllDocsQuery will be used");
        }
        return "";
    }

    public String convert(Sort sort) {
        if (sort == null || sort.getSort() == null) {
            return "";
        }
        List<SortField> fields = Arrays.asList(sort.getSort());
        String sortString = fields.stream().filter(sortField -> sortField.getField() != null).map(sortField -> {
            String key = this.converterImpl.convertKey(sortField.getField());
            String sortDirection = ASC;
            if (sortField.getReverse()) {
                sortDirection = DESC;
            }
            return key + " " + sortDirection;
        }).collect(Collectors.joining(","));
        return sortString;
    }

    public String where(Query query) {
        String queryString = this.convert(query);
        if (queryString.isEmpty()) {
            return "";
        }
        return WHERE + queryString;
    }

    public String sort(Sort sort) {
        String sortString = this.convert(sort);
        if (sortString.isEmpty()) {
            return "";
        }
        return ORDER_BY + sortString;
    }
}

