/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.organizationalunit.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.security.ResourceType;
import org.uberfire.spaces.Space;

@Portable
public class OrganizationalUnitImpl
implements OrganizationalUnit {
    private String name;
    private String defaultGroupId;
    private Collection<Repository> repositories = new ArrayList<Repository>();
    private Collection<String> groups = new ArrayList<String>();
    private Collection<Contributor> contributors = new ArrayList<Contributor>();
    private boolean requiresRefresh = true;

    public OrganizationalUnitImpl() {
    }

    public OrganizationalUnitImpl(String name, String defaultGroupId) {
        this.name = name;
        this.defaultGroupId = defaultGroupId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Space getSpace() {
        return new Space(this.name);
    }

    @Override
    public String getOwner() {
        Optional<Contributor> owner = this.contributors.stream().filter(c -> c.getType().equals((Object)ContributorType.OWNER)).findFirst();
        return owner.map(Contributor::getUsername).orElse(null);
    }

    @Override
    public String getDefaultGroupId() {
        return this.defaultGroupId;
    }

    @Override
    public Collection<Repository> getRepositories() {
        return this.repositories;
    }

    public String getIdentifier() {
        return this.getName();
    }

    public ResourceType getResourceType() {
        return RESOURCE_TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrganizationalUnitImpl)) {
            return false;
        }
        OrganizationalUnitImpl ou = (OrganizationalUnitImpl)o;
        if (this.name != null ? !this.name.equals(ou.name) : ou.name != null) {
            return false;
        }
        return !(this.defaultGroupId != null ? !this.defaultGroupId.equals(ou.defaultGroupId) : ou.defaultGroupId != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = ~(~result);
        result = 31 * result + (this.defaultGroupId != null ? this.defaultGroupId.hashCode() : 0);
        result = ~(~result);
        return result;
    }

    public String toString() {
        return "OrganizationalUnitImpl [name=" + this.name + ", repositories=" + this.repositories + ", groups=" + this.groups + ", contributors=" + this.contributors + ", defaultGroupId=" + this.defaultGroupId + "]";
    }

    public void markAsCached() {
        this.requiresRefresh = false;
    }

    public boolean requiresRefresh() {
        return this.requiresRefresh;
    }

    @Override
    public Collection<String> getGroups() {
        return this.groups;
    }

    @Override
    public Collection<Contributor> getContributors() {
        return this.contributors;
    }
}

