/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.inmemory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.registry.inmemory.util.PageSortUtil;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.kie.soup.commons.validation.PortablePreconditions;

@ApplicationScoped
public class InMemoryRuntimeRegistry
implements RuntimeRegistry {
    protected Map<ProviderType, ProviderType> providerTypes = new ConcurrentHashMap<ProviderType, ProviderType>();
    protected Map<String, Provider> providers = new ConcurrentHashMap<String, Provider>();
    protected Map<String, Runtime> runtimes = new ConcurrentHashMap<String, Runtime>();

    @Override
    public void registerProviderType(ProviderType providerType) {
        PortablePreconditions.checkNotNull((String)"providerType", (Object)providerType);
        this.providerTypes.put(providerType, providerType);
    }

    @Override
    public List<ProviderType> getProviderTypes(Integer page, Integer pageSize, String sort, boolean sortOrder) {
        Collection<ProviderType> values = this.providerTypes.values();
        return PageSortUtil.pageSort(values, (pt1, pt2) -> {
            switch (sort) {
                case "providerTypeName": {
                    return pt1.getProviderTypeName().compareTo(pt2.getProviderTypeName());
                }
                case "version": {
                    return pt1.getVersion().compareTo(pt2.getVersion());
                }
            }
            return pt1.toString().compareTo(pt2.toString());
        }, page, pageSize, sort, sortOrder);
    }

    @Override
    public void deregisterProviderType(ProviderType providerType) {
        PortablePreconditions.checkNotNull((String)"providerType", (Object)providerType);
        this.providerTypes.remove(providerType);
    }

    @Override
    public void registerProvider(Provider provider) {
        PortablePreconditions.checkNotNull((String)"provider", (Object)provider);
        this.providers.put(provider.getId(), provider);
    }

    @Override
    public List<Provider> getProviders(Integer page, Integer pageSize, String sort, boolean sortOrder) {
        Collection<Provider> values = this.providers.values();
        return PageSortUtil.pageSort(values, (p1, p2) -> {
            switch (sort) {
                case "id": {
                    return p1.getId().compareTo(p2.getId());
                }
                case "providerTypeName": {
                    return p1.getProviderType().getProviderTypeName().compareTo(p2.getProviderType().getProviderTypeName());
                }
                case "version": {
                    return p1.getProviderType().getVersion().compareTo(p2.getProviderType().getVersion());
                }
            }
            return p1.toString().compareTo(p2.toString());
        }, page, pageSize, sort, sortOrder);
    }

    @Override
    public List<Provider> getProvidersByType(ProviderType providerType) {
        PortablePreconditions.checkNotNull((String)"providerType", (Object)providerType);
        return this.providers.values().stream().filter(provider -> providerType.equals(provider.getProviderType())).collect(Collectors.toList());
    }

    @Override
    public Provider getProvider(String providerId) {
        PortablePreconditions.checkNotNull((String)"providerId", (Object)providerId);
        return this.providers.get(providerId);
    }

    @Override
    public void deregisterProvider(Provider provider) {
        PortablePreconditions.checkNotNull((String)"provider", (Object)provider);
        this.providers.remove(provider.getId());
    }

    @Override
    public void deregisterProvider(String providerId) {
        PortablePreconditions.checkNotNull((String)"providerId", (Object)providerId);
        this.providers.remove(providerId);
    }

    @Override
    public void registerRuntime(Runtime runtime) {
        PortablePreconditions.checkNotNull((String)"runtime", (Object)runtime);
        this.runtimes.put(runtime.getId(), runtime);
    }

    @Override
    public List<Runtime> getRuntimes(Integer page, Integer pageSize, String sort, boolean sortOrder) {
        Collection<Runtime> values = this.runtimes.values();
        return PageSortUtil.pageSort(values, (r1, r2) -> {
            switch (sort) {
                case "id": {
                    return r1.getId().compareTo(r2.getId());
                }
                case "state": {
                    return r1.getState().getState().compareTo(r2.getState().getState());
                }
            }
            return r1.toString().compareTo(r2.toString());
        }, page, pageSize, sort, sortOrder);
    }

    @Override
    public Runtime getRuntimeById(String runtimeId) {
        PortablePreconditions.checkNotNull((String)"runtimeId", (Object)runtimeId);
        return this.runtimes.get(runtimeId);
    }

    @Override
    public void deregisterRuntime(RuntimeId runtimeId) {
        PortablePreconditions.checkNotNull((String)"runtimeId", (Object)runtimeId);
        this.runtimes.remove(runtimeId.getId());
    }

    @Override
    public <T extends Provider> Optional<T> getProvider(ProviderId providerId, Class<T> clazz) {
        PortablePreconditions.checkNotNull((String)"providerId", (Object)providerId);
        PortablePreconditions.checkNotNull((String)"clazz", clazz);
        Provider value = this.providers.get(providerId.getId());
        return Optional.ofNullable(value).filter(provider -> clazz.isInstance(provider)).map(provider -> (Provider)clazz.cast(provider));
    }
}

