/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.expr;

import java.math.BigInteger;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.LiteralStringValueExpr;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.LongLiteralExprMetaModel;

public final class BigIntegerLiteralExpr
extends LiteralStringValueExpr {
    public BigIntegerLiteralExpr() {
        this(null, "0");
    }

    @AllFieldsConstructor
    public BigIntegerLiteralExpr(String value) {
        this(null, value);
    }

    public BigIntegerLiteralExpr(TokenRange tokenRange, String value) {
        super(tokenRange, value);
        this.customInitialization();
    }

    public BigIntegerLiteralExpr(BigInteger value) {
        this(null, value.toString());
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.getRuleGenericVisitor().visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.getRuleVisitor().visit(this, arg);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    public BigInteger asBigInteger() {
        String result = this.value.replaceAll("_", "");
        char lastChar = result.charAt(result.length() - 1);
        if (lastChar == 'I') {
            result = result.substring(0, result.length() - 1);
        }
        return new BigInteger(result);
    }

    public BigIntegerLiteralExpr setLong(long value) {
        this.value = String.valueOf(value);
        return this;
    }

    @Override
    public BigIntegerLiteralExpr clone() {
        return (BigIntegerLiteralExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public LongLiteralExprMetaModel getMetaModel() {
        return JavaParserMetaModel.longLiteralExprMetaModel;
    }
}

