/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl;

import java.util.function.Predicate;
import org.kie.workbench.common.forms.migration.legacy.model.DataHolder;
import org.kie.workbench.common.forms.migration.legacy.model.Form;
import org.kie.workbench.common.forms.migration.tool.FormMigrationSummary;
import org.kie.workbench.common.forms.migration.tool.pipelines.MigrationContext;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.AbstractFormAdapter;
import org.kie.workbench.common.forms.model.FormModel;

public class DataObjectFormAdapter
extends AbstractFormAdapter {
    public DataObjectFormAdapter(MigrationContext migrationContext) {
        super(migrationContext);
    }

    @Override
    protected FormModel extractFormModel(FormMigrationSummary summary) {
        DataHolder dataHolder = summary.getOriginalForm().get().getHolders().iterator().next();
        return this.createModelForDO(dataHolder);
    }

    @Override
    protected Predicate<FormMigrationSummary> getFilter() {
        return summary -> {
            if (summary.getBaseFormName().endsWith("-taskform")) {
                return false;
            }
            Form origin = summary.getOriginalForm().get();
            if (origin.getHolders().size() != 1) {
                this.fail((FormMigrationSummary)summary, "Wrong number of DataHolders (" + origin.getHolders().size() + ") for a Data Object form");
                return false;
            }
            DataHolder dataHolder = origin.getHolders().iterator().next();
            if ("basicType".equals(dataHolder.getType())) {
                this.fail((FormMigrationSummary)summary, "Invalid DataHolder type (" + dataHolder.getClassName() + ") for a Data Object form");
                return false;
            }
            return true;
        };
    }
}

