/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.script.NativeScriptEngineService;
import org.elasticsearch.script.NativeScriptFactory;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptContextRegistry;
import org.elasticsearch.script.ScriptEngineRegistry;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptSettings;
import org.elasticsearch.watcher.ResourceWatcherService;

public class ScriptModule {
    private final ScriptSettings scriptSettings;
    private final ScriptService scriptService;

    public static ScriptModule create(Settings settings, Environment environment, ResourceWatcherService resourceWatcherService, List<ScriptPlugin> scriptPlugins) {
        Map<String, NativeScriptFactory> factoryMap = scriptPlugins.stream().flatMap(x -> x.getNativeScripts().stream()).collect(Collectors.toMap(NativeScriptFactory::getName, Function.identity()));
        NativeScriptEngineService nativeScriptEngineService = new NativeScriptEngineService(settings, factoryMap);
        List<ScriptEngineService> scriptEngineServices = scriptPlugins.stream().map(x -> x.getScriptEngineService(settings)).filter(Objects::nonNull).collect(Collectors.toList());
        scriptEngineServices.add(nativeScriptEngineService);
        List<ScriptContext.Plugin> plugins = scriptPlugins.stream().map(x -> x.getCustomScriptContexts()).filter(Objects::nonNull).collect(Collectors.toList());
        return new ScriptModule(settings, environment, resourceWatcherService, scriptEngineServices, plugins);
    }

    public ScriptModule(Settings settings, Environment environment, ResourceWatcherService resourceWatcherService, List<ScriptEngineService> scriptEngineServices, List<ScriptContext.Plugin> customScriptContexts) {
        ScriptContextRegistry scriptContextRegistry = new ScriptContextRegistry(customScriptContexts);
        ScriptEngineRegistry scriptEngineRegistry = new ScriptEngineRegistry(scriptEngineServices);
        this.scriptSettings = new ScriptSettings(scriptEngineRegistry, scriptContextRegistry);
        try {
            this.scriptService = new ScriptService(settings, environment, resourceWatcherService, scriptEngineRegistry, scriptContextRegistry, this.scriptSettings);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't setup ScriptService", e);
        }
    }

    public List<Setting<?>> getSettings() {
        return this.scriptSettings.getSettings();
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void registerClusterSettingsListeners(ClusterSettings clusterSettings) {
        this.scriptService.registerClusterSettingsListeners(clusterSettings);
    }
}

