/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.exporter;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.jboss.errai.ioc.client.QualifierUtil;
import org.jboss.errai.ioc.client.container.SyncBeanDef;

public class SingletonBeanDef<T, B extends T>
implements SyncBeanDef<T> {
    private final B instance;
    private final Class<T> type;
    private final Set<Annotation> qualifiers;
    private final String name;
    private final boolean activated;
    private final Set<Class<?>> assignableTypes = new HashSet();

    public SingletonBeanDef(B instance, Class<T> type, Set<Annotation> qualifiers, String name, boolean activated, Class<?> ... otherAssignableTypes) {
        this.instance = instance;
        this.type = type;
        this.qualifiers = qualifiers;
        this.name = name;
        this.activated = activated;
        this.assignableTypes.add(type);
        this.assignableTypes.addAll(Arrays.asList(otherAssignableTypes));
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<?> getBeanClass() {
        return this.instance.getClass();
    }

    public Class<? extends Annotation> getScope() {
        return Singleton.class;
    }

    public T getInstance() {
        return (T)this.instance;
    }

    public T newInstance() {
        throw new UnsupportedOperationException();
    }

    public Set<Annotation> getQualifiers() {
        if (this.qualifiers == null) {
            return Collections.emptySet();
        }
        return this.qualifiers;
    }

    public boolean matches(Set<Annotation> annotations) {
        return QualifierUtil.matches(annotations, this.getQualifiers());
    }

    public String getName() {
        return this.name;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean isAssignableTo(Class<?> type) {
        return this.assignableTypes.contains(type);
    }
}

