/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.drools.model.impl.NamesGenerator;

public class DRLIdGenerator {
    private Map<PatternTypeDRLConstraint, String> generatedExprIds = new HashMap<PatternTypeDRLConstraint, String>();
    private Map<PatternTypeDRLConstraint, String> generatedCondIds = new HashMap<PatternTypeDRLConstraint, String>();
    private Map<PatternTypeDRLConstraint, String> generateOOPathId = new HashMap<PatternTypeDRLConstraint, String>();
    private Map<PatternTypeDRLConstraint, String> generateUnificationVariableId = new HashMap<PatternTypeDRLConstraint, String>();
    private Map<PatternTypeDRLConstraint, String> generateAccumulateBindingId = new HashMap<PatternTypeDRLConstraint, String>();

    public String getExprId(Class<?> patternType, String drlConstraint) {
        PatternTypeDRLConstraint key = PatternTypeDRLConstraint.of(patternType, drlConstraint);
        return this.generatedExprIds.computeIfAbsent(key, k -> this.generateNewId());
    }

    public String getCondId(Class<?> patternType, String drlConstraint) {
        PatternTypeDRLConstraint key = PatternTypeDRLConstraint.of(patternType, drlConstraint);
        return this.generatedCondIds.computeIfAbsent(key, k -> this.generateNewCond());
    }

    public String getOOPathId(Class<?> patternType, String drlConstraint) {
        PatternTypeDRLConstraint key = PatternTypeDRLConstraint.of(patternType, drlConstraint);
        return this.generateOOPathId.computeIfAbsent(key, k -> this.generateOOPathExpr());
    }

    public String getOrCreateUnificationVariable(String drlConstraint) {
        PatternTypeDRLConstraint key = PatternTypeDRLConstraint.of(Object.class, drlConstraint);
        return this.generateUnificationVariableId.computeIfAbsent(key, k -> this.generateUnificationExpr());
    }

    public Optional<String> getUnificationVariable(String drlConstraint) {
        PatternTypeDRLConstraint key = PatternTypeDRLConstraint.of(Object.class, drlConstraint);
        return Optional.ofNullable(this.generateUnificationVariableId.get(key));
    }

    public String getOrCreateAccumulateBindingId(String drlConstraint) {
        PatternTypeDRLConstraint key = PatternTypeDRLConstraint.of(Object.class, drlConstraint);
        return this.generateAccumulateBindingId.computeIfAbsent(key, k -> this.generateAccumulatorBindingId());
    }

    private String generateNewId() {
        return NamesGenerator.generateName((String)"expr");
    }

    private String generateNewCond() {
        return NamesGenerator.generateName((String)"cond");
    }

    private String generateOOPathExpr() {
        return NamesGenerator.generateName((String)"ooChunk");
    }

    private String generateUnificationExpr() {
        return NamesGenerator.generateName((String)"unificationExpr");
    }

    private String generateAccumulatorBindingId() {
        return NamesGenerator.generateName((String)"accBindingId");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.generatedExprIds.forEach((k, v) -> sb.append(v + ": " + k + "\n"));
        return sb.toString();
    }

    private static class PatternTypeDRLConstraint {
        public final Class<?> patternType;
        public final String drlConstraint;

        public PatternTypeDRLConstraint(Class<?> patternType, String drlConstraint) {
            this.patternType = patternType;
            this.drlConstraint = drlConstraint;
        }

        public static PatternTypeDRLConstraint of(Class<?> patternType, String drlConstraint) {
            return new PatternTypeDRLConstraint(patternType, drlConstraint);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.drlConstraint == null ? 0 : this.drlConstraint.hashCode());
            result = 31 * result + (this.patternType == null ? 0 : this.patternType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PatternTypeDRLConstraint other = (PatternTypeDRLConstraint)obj;
            if (this.drlConstraint == null ? other.drlConstraint != null : !this.drlConstraint.equals(other.drlConstraint)) {
                return false;
            }
            return !(this.patternType == null ? other.patternType != null : !this.patternType.equals(other.patternType));
        }

        public String toString() {
            return "" + (this.patternType != null ? this.patternType.getName() : "<no patternType>") + "( " + this.drlConstraint + " )";
        }
    }
}

