/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.pattern;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseFail;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.ParseResultVisitor;
import org.drools.modelcompiler.builder.generator.visitor.DSLNode;
import org.drools.modelcompiler.builder.generator.visitor.pattern.FlowDSLSimpleConstraint;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternConstraintParseResult;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternDSL;

class FlowDSLPattern
extends PatternDSL {
    public FlowDSLPattern(RuleContext context, PackageModel packageModel, PatternDescr pattern, List<? extends BaseDescr> constraintDescrs, Class<?> patternType, boolean allConstraintsPositional) {
        super(context, packageModel, pattern, constraintDescrs, allConstraintsPositional, patternType);
    }

    @Override
    protected void buildPattern(DeclarationSpec declarationSpec, List<PatternConstraintParseResult> patternConstraintParseResults) {
        if (this.shouldAddInputPattern(patternConstraintParseResults)) {
            this.context.addExpression((Expression)this.input(declarationSpec));
        }
        this.buildConstraints(this.pattern, this.patternType, patternConstraintParseResults, this.allConstraintsPositional);
    }

    @Override
    public MethodCallExpr input(DeclarationSpec declarationSpec) {
        return this.createInputExpression(this.pattern, declarationSpec);
    }

    private boolean shouldAddInputPattern(List<PatternConstraintParseResult> parseResults) {
        Predicate<PatternConstraintParseResult> hasOneOOPathExpr = patternConstraintParseResult -> patternConstraintParseResult.getDrlxParseResult().acceptWithReturnValue(new ParseResultVisitor<Boolean>(){

            @Override
            public Boolean onSuccess(DrlxParseSuccess drlxParseResult) {
                return drlxParseResult.getExpr() instanceof OOPathExpr;
            }

            @Override
            public Boolean onFail(DrlxParseFail failure) {
                return false;
            }
        });
        return parseResults.stream().anyMatch(hasOneOOPathExpr);
    }

    private MethodCallExpr createInputExpression(PatternDescr pattern, DeclarationSpec declarationSpec) {
        Set<String> settableWatchedProps;
        MethodCallExpr exprDSL = new MethodCallExpr(null, "D.input");
        exprDSL.addArgument(this.context.getVarExpr(pattern.getIdentifier()));
        if (this.context.isQuery() && declarationSpec.getDeclarationSource().isPresent()) {
            exprDSL.addArgument(declarationSpec.getDeclarationSource().get());
        }
        if (!(settableWatchedProps = this.getSettableWatchedProps()).isEmpty()) {
            exprDSL = new MethodCallExpr((Expression)exprDSL, "watch");
            settableWatchedProps.stream().map(StringLiteralExpr::new).forEach(arg_0 -> ((MethodCallExpr)exprDSL).addArgument(arg_0));
        }
        return exprDSL;
    }

    private void buildConstraints(PatternDescr pattern, Class<?> patternType, List<PatternConstraintParseResult> patternConstraintParseResults, boolean allConstraintsPositional) {
        if (allConstraintsPositional) {
            MethodCallExpr andDSL = new MethodCallExpr(null, "D.and");
            this.context.addExpression((Expression)andDSL);
            this.context.pushExprPointer(arg_0 -> ((MethodCallExpr)andDSL).addArgument(arg_0));
        }
        for (PatternConstraintParseResult patternConstraintParseResult : patternConstraintParseResults) {
            this.buildConstraint(pattern, patternType, patternConstraintParseResult);
        }
        if (allConstraintsPositional) {
            this.context.popExprPointer();
        }
    }

    @Override
    protected DSLNode createSimpleConstraint(DrlxParseSuccess drlxParseResult, PatternDescr pattern) {
        return new FlowDSLSimpleConstraint(this.context, pattern, drlxParseResult);
    }
}

