/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.drlx;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import org.drools.core.impl.InternalRuleUnitExecutor;
import org.drools.core.ruleunit.RuleUnitFactory;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;

public class CompiledUnit {
    private final List<String> unitNames;
    private final KieContainer kieContainer;
    private InternalRuleUnitExecutor executor;

    public CompiledUnit(KieContainer kieContainer, String unitName) {
        this(kieContainer, Collections.singletonList(unitName));
    }

    public CompiledUnit(KieContainer kieContainer, List<String> unitNames) {
        this.kieContainer = kieContainer;
        this.unitNames = unitNames;
    }

    public RuleUnitExecutor createExecutor() {
        KieBase kbase = this.kieContainer.getKieBase();
        this.executor = (InternalRuleUnitExecutor)RuleUnitExecutor.create();
        return this.executor.bind(kbase);
    }

    public String getName() {
        return this.unitNames.get(0);
    }

    private ClassLoader getClassLoader() {
        return this.kieContainer.getClassLoader();
    }

    public RuleUnit getOrCreateRuleUnit() {
        return new RuleUnitFactory().getOrCreateRuleUnit(this.executor, this.getName(), this.getClassLoader());
    }

    public Constructor<?> getConstructorFor(String className, Class<?> ... parameterTypes) {
        try {
            Class<?> domainClass = Class.forName(className, true, this.getClassLoader());
            return domainClass.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

