/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.persistence;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import org.ext.uberfire.social.activities.model.SocialUser;

public class SocialUserJsonSerializer
implements JsonSerializer<SocialUser> {
    public JsonElement serialize(SocialUser socialUser, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userName", socialUser.getUserName());
        jsonObject.addProperty("realName", socialUser.getRealName());
        jsonObject.addProperty("email", socialUser.getEmail());
        this.serializeList(socialUser, "following", socialUser.getFollowingName(), jsonObject);
        this.serializeList(socialUser, "followers", socialUser.getFollowersName(), jsonObject);
        return jsonObject;
    }

    private void serializeList(SocialUser socialUser, String jsonName, List<String> list, JsonObject jsonObject) {
        JsonArray jsonArray = new JsonArray();
        for (String field : list) {
            JsonPrimitive jsonSocialType = new JsonPrimitive(field);
            jsonArray.add((JsonElement)jsonSocialType);
        }
        jsonObject.add(jsonName, (JsonElement)jsonArray);
    }
}

