/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Reflect {
  @JsFunction
  public interface ApplyTargetCallbackFn<RESULT> {
    RESULT onInvoke(Object... p0);
  }

  @JsFunction
  public interface ConstructNewTargetCallbackFn {
    Object onInvoke(Object... p0);
  }

  @JsFunction
  public interface ConstructTargetCallbackFn {
    Object onInvoke(Object... p0);
  }

  public static native <RESULT> RESULT apply(
      ApplyTargetCallbackFn<RESULT> target, Object thisArg, Array argList);

  public static native <TARGET> TARGET construct(
      ConstructTargetCallbackFn target, Array argList, ConstructNewTargetCallbackFn newTarget);

  public static native <TARGET> TARGET construct(ConstructTargetCallbackFn target, Array argList);

  public static native boolean defineProperty(
      JsObject target, String propertyKey, JsObject attributes);

  public static native boolean deleteProperty(JsObject target, String propertyKey);

  public static native Object get(JsObject target, String propertyKey, JsObject receiver);

  public static native Object get(JsObject target, String propertyKey);

  public static native ObjectPropertyDescriptor getOwnPropertyDescriptor(
      JsObject target, String propertyKey);

  public static native JsObject getPrototypeOf(JsObject target);

  public static native boolean has(JsObject target, String propertyKey);

  public static native boolean isExtensible(JsObject target);

  public static native Object[] ownKeys(JsObject target);

  public static native boolean preventExtensions(JsObject target);

  public static native boolean set(
      JsObject target, String propertyKey, Object value, JsObject receiver);

  public static native boolean set(JsObject target, String propertyKey, Object value);

  public static native boolean setPrototypeOf(JsObject target, JsObject proto);
}
