/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.promise.Promise;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface WorkerGlobalScope extends EventTarget {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface FetchInputUnionType {
    @JsOverlay
    static FetchInputUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Request asRequest() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isRequest() {
      return (Object) this instanceof Request;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsFunction
  public interface OnerrorCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnofflineCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnonlineCallbackFn {
    Object onInvoke(Event p0);
  }

  void close();

  Promise<Response> fetch(FetchInputUnionType input, RequestInit init);

  Promise<Response> fetch(FetchInputUnionType input);

  @JsOverlay
  default Promise<Response> fetch(Request input, RequestInit init) {
    return fetch(Js.<FetchInputUnionType>uncheckedCast(input), init);
  }

  @JsOverlay
  default Promise<Response> fetch(Request input) {
    return fetch(Js.<FetchInputUnionType>uncheckedCast(input));
  }

  @JsOverlay
  default Promise<Response> fetch(String input, RequestInit init) {
    return fetch(Js.<FetchInputUnionType>uncheckedCast(input), init);
  }

  @JsOverlay
  default Promise<Response> fetch(String input) {
    return fetch(Js.<FetchInputUnionType>uncheckedCast(input));
  }

  @JsProperty
  WorkerLocation getLocation();

  @JsProperty
  OnerrorCallbackFn getOnerror();

  @JsProperty
  OnofflineCallbackFn getOnoffline();

  @JsProperty
  OnonlineCallbackFn getOnonline();

  @JsProperty
  WorkerGlobalScope getSelf();

  @JsProperty
  void setLocation(WorkerLocation location);

  @JsProperty
  void setOnerror(OnerrorCallbackFn onerror);

  @JsProperty
  void setOnoffline(OnofflineCallbackFn onoffline);

  @JsProperty
  void setOnonline(OnonlineCallbackFn ononline);

  @JsProperty
  void setSelf(WorkerGlobalScope self);
}
