/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.spi;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.drools.core.base.ClassObjectType;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.ruleunit.RuleUnitDescription;
import org.drools.core.spi.AcceptsClassObjectType;
import org.drools.core.spi.GlobalDateExtractor;
import org.drools.core.spi.GlobalExtractor;
import org.drools.core.spi.GlobalNumberExtractor;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;

public class DeclarationScopeResolver {
    private final Stack<RuleConditionElement> buildStack;
    private final Map<String, Class<?>> globalMap;
    private final InternalKnowledgePackage pkg;
    private RuleImpl rule;
    private Optional<RuleUnitDescription> ruleUnitDescr = Optional.empty();

    protected DeclarationScopeResolver() {
        this(new HashMap(), new Stack<RuleConditionElement>());
    }

    public DeclarationScopeResolver(Map<String, Class<?>> globalMap, Stack<RuleConditionElement> buildStack) {
        this(globalMap, buildStack, null);
    }

    public DeclarationScopeResolver(Map<String, Class<?>> globalMap, InternalKnowledgePackage pkg) {
        this(globalMap, new Stack<RuleConditionElement>(), pkg);
    }

    private DeclarationScopeResolver(Map<String, Class<?>> globalMap, Stack<RuleConditionElement> buildStack, InternalKnowledgePackage pkg) {
        this.globalMap = globalMap;
        this.buildStack = buildStack;
        this.pkg = pkg;
    }

    public void setRule(RuleImpl rule) {
        this.rule = rule;
        this.ruleUnitDescr = this.pkg.getRuleUnitDescriptionLoader().getDescription(rule);
    }

    public RuleConditionElement peekBuildStack() {
        return this.buildStack.peek();
    }

    public RuleConditionElement popBuildStack() {
        return this.buildStack.pop();
    }

    public void pushOnBuildStack(RuleConditionElement element) {
        this.buildStack.push(element);
    }

    private Declaration getExtendedDeclaration(RuleImpl rule, String identifier) {
        Declaration declaration = rule.getLhs().resolveDeclaration(identifier);
        if (declaration != null) {
            return declaration;
        }
        return rule.getParent() == null ? null : this.getExtendedDeclaration(rule.getParent(), identifier);
    }

    private Map<String, Declaration> getAllExtendedDeclaration(RuleImpl rule, Map<String, Declaration> dec) {
        dec.putAll(rule.getLhs().getInnerDeclarations());
        if (null != rule.getParent()) {
            return this.getAllExtendedDeclaration(rule.getParent(), dec);
        }
        return dec;
    }

    public Declaration getDeclaration(String identifier) {
        Declaration parentDeclaration;
        for (int i = this.buildStack.size() - 1; i >= 0; --i) {
            Declaration declaration = ((RuleConditionElement)this.buildStack.get(i)).resolveDeclaration(identifier);
            if (declaration == null) continue;
            return declaration;
        }
        if (this.rule != null && this.rule.getParent() != null && null != (parentDeclaration = this.getExtendedDeclaration(this.rule.getParent(), identifier))) {
            return parentDeclaration;
        }
        Class<?> cls = this.resolveVarType(identifier);
        if (cls != null) {
            ClassObjectType classObjectType = new ClassObjectType(cls);
            Pattern dummy = new Pattern(0, classObjectType);
            InternalReadAccessor globalExtractor = DeclarationScopeResolver.getReadAcessor(identifier, classObjectType);
            Declaration declaration = new Declaration(identifier, globalExtractor, dummy);
            if (this.pkg != null) {
                this.pkg.getClassFieldAccessorStore().wireObjectType(classObjectType, dummy);
                this.pkg.getClassFieldAccessorStore().wireObjectType(classObjectType, (AcceptsClassObjectType)((Object)globalExtractor));
            }
            return declaration;
        }
        return null;
    }

    public Class<?> resolveVarType(String identifier) {
        return this.ruleUnitDescr.flatMap(unit -> unit.getVarType(identifier)).orElseGet(() -> this.globalMap.get(identifier));
    }

    public String normalizeValueForUnit(String value) {
        return this.ruleUnitDescr.map(unit -> {
            int dotPos = value.indexOf(46);
            String firstPart = dotPos > 0 ? value.substring(0, dotPos) : value;
            return unit.hasVar(firstPart) ? "$$unit." + value : value;
        }).orElse(value);
    }

    public boolean hasDataSource(String name) {
        return this.ruleUnitDescr.map(descr -> descr.hasDataSource(name)).orElse(false);
    }

    private static InternalReadAccessor getReadAcessor(String identifier, ObjectType objectType) {
        Class<?> returnType = ((ClassObjectType)objectType).getClassType();
        if (Number.class.isAssignableFrom(returnType) || returnType == Byte.TYPE || returnType == Short.TYPE || returnType == Integer.TYPE || returnType == Long.TYPE || returnType == Float.TYPE || returnType == Double.TYPE) {
            return new GlobalNumberExtractor(identifier, objectType);
        }
        if (Date.class.isAssignableFrom(returnType)) {
            return new GlobalDateExtractor(identifier, objectType);
        }
        return new GlobalExtractor(identifier, objectType);
    }

    public boolean available(RuleImpl rule, String name) {
        Declaration parentDeclaration;
        for (int i = this.buildStack.size() - 1; i >= 0; --i) {
            Declaration declaration = ((RuleConditionElement)this.buildStack.get(i)).resolveDeclaration(name);
            if (declaration == null) continue;
            return true;
        }
        if (this.globalMap.containsKey(name)) {
            return true;
        }
        return rule != null && rule.getParent() != null && null != (parentDeclaration = this.getExtendedDeclaration(rule.getParent(), name));
    }

    public boolean isDuplicated(RuleImpl rule, String name, String type) {
        if (this.globalMap.containsKey(name)) {
            return true;
        }
        for (int i = this.buildStack.size() - 1; i >= 0; --i) {
            boolean inOr;
            RuleConditionElement rce = (RuleConditionElement)this.buildStack.get(i);
            Declaration declaration = rce.resolveDeclaration(name);
            if (declaration == null) continue;
            boolean bl = inOr = rce instanceof GroupElement && ((GroupElement)rce).isOr();
            if (!inOr || type == null) {
                return !inOr;
            }
            return !declaration.getDeclarationClass().getName().equals(type);
        }
        if (rule != null && rule.getParent() != null) {
            Declaration parentDeclaration = this.getExtendedDeclaration(rule.getParent(), name);
            return null != parentDeclaration;
        }
        return false;
    }

    public Map<String, Declaration> getDeclarations(RuleImpl rule) {
        return this.getDeclarations(rule, "default");
    }

    public Map<String, Declaration> getDeclarations(RuleImpl rule, String consequenceName) {
        HashMap<String, Declaration> declarations = new HashMap<String, Declaration>();
        for (RuleConditionElement aBuildStack : this.buildStack) {
            if (aBuildStack instanceof GroupElement && ((GroupElement)aBuildStack).getType() == GroupElement.Type.OR) continue;
            Map<String, Declaration> innerDeclarations = aBuildStack instanceof GroupElement ? ((GroupElement)aBuildStack).getInnerDeclarations(consequenceName) : aBuildStack.getInnerDeclarations();
            declarations.putAll(innerDeclarations);
        }
        if (null != rule.getParent()) {
            return this.getAllExtendedDeclaration(rule.getParent(), declarations);
        }
        return declarations;
    }

    public Map<String, Class<?>> getDeclarationClasses(RuleImpl rule) {
        return DeclarationScopeResolver.getDeclarationClasses(this.getDeclarations(rule));
    }

    public static Map<String, Class<?>> getDeclarationClasses(Map<String, Declaration> declarations) {
        HashMap classes = new HashMap();
        for (Map.Entry<String, Declaration> decl : declarations.entrySet()) {
            Class<?> declarationClass = decl.getValue().getDeclarationClass();
            if (declarationClass == null) continue;
            classes.put(decl.getKey(), declarationClass);
        }
        return classes;
    }

    public Pattern findPatternByIndex(int index) {
        if (!this.buildStack.isEmpty()) {
            return this.findPatternInNestedElements(index, (RuleConditionElement)this.buildStack.get(0));
        }
        return null;
    }

    private Pattern findPatternInNestedElements(int index, RuleConditionElement rce) {
        for (RuleConditionElement ruleConditionElement : rce.getNestedElements()) {
            Pattern p;
            if (!(ruleConditionElement instanceof Pattern ? (p = (Pattern)ruleConditionElement).getIndex() == index : !ruleConditionElement.isPatternScopeDelimiter() && (p = this.findPatternInNestedElements(index, ruleConditionElement)) != null)) continue;
            return p;
        }
        return null;
    }
}

