/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.filters.HiddenBranchRefFilter;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;

public class GitUploadCommand
extends BaseGitCommand {
    private UploadPackFactory<BaseGitCommand> uploadPackFactory;

    public GitUploadCommand(String command, JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, FileSystemAuthorizer fileSystemAuthorizer, UploadPackFactory uploadPackFactory, ExecutorService executorService) {
        super(command, fileSystemAuthorizer, repositoryResolver, executorService);
        this.uploadPackFactory = uploadPackFactory;
    }

    @Override
    protected String getCommandName() {
        return "git-upload-pack";
    }

    @Override
    protected void execute(FileSystemUser user, Repository repository, InputStream in, OutputStream out, OutputStream err, JGitFileSystem fileSystem) {
        try {
            UploadPack up = this.uploadPackFactory.create((Object)this, repository);
            PackConfig config = new PackConfig(repository);
            config.setCompressionLevel(9);
            up.setPackConfig(config);
            if (up.getRefFilter() == RefFilter.DEFAULT) {
                up.setRefFilter((RefFilter)new HiddenBranchRefFilter());
            }
            up.upload(in, out, err);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

