/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.List;
import javax.inject.Inject;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

public class OrganizationalUnitFactoryImpl
implements OrganizationalUnitFactory {
    private RepositoryService repositoryService;
    private BackwardCompatibleUtil backward;
    private SpacesAPI spacesAPI;
    private ConfigurationService configurationService;
    private ConfigurationFactory configurationFactory;

    @Inject
    public OrganizationalUnitFactoryImpl(RepositoryService repositoryService, BackwardCompatibleUtil backward, SpacesAPI spacesAPI, ConfigurationService configurationService, ConfigurationFactory configurationFactory) {
        this.repositoryService = repositoryService;
        this.backward = backward;
        this.spacesAPI = spacesAPI;
        this.configurationService = configurationService;
        this.configurationFactory = configurationFactory;
    }

    public OrganizationalUnit newOrganizationalUnit(ConfigGroup groupConfig) {
        ConfigItem groups;
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(groupConfig.getName(), groupConfig.getConfigItemValue("defaultGroupId"));
        ConfigItem repositories = groupConfig.getConfigItem("repositories");
        if (repositories != null) {
            for (String alias : (List)repositories.getValue()) {
                Space space = this.spacesAPI.getSpace(organizationalUnit.getName());
                Repository repo = this.repositoryService.getRepositoryFromSpace(space, alias);
                if (repo == null) continue;
                organizationalUnit.getRepositories().add(repo);
            }
        }
        if ((groups = this.backward.compat(groupConfig).getConfigItem("security:groups")) != null) {
            for (String group : (List)groups.getValue()) {
                organizationalUnit.getGroups().add(group);
            }
        }
        this.fillOrganizationalUnitContributors(groupConfig, (OrganizationalUnit)organizationalUnit);
        return organizationalUnit;
    }

    private void fillOrganizationalUnitContributors(ConfigGroup configGroup, OrganizationalUnit organizationalUnit) {
        ConfigItem oldContributors;
        boolean shouldUpdateConfigGroup = false;
        String oldOwner = configGroup.getConfigItemValue("owner");
        if (oldOwner != null) {
            shouldUpdateConfigGroup = true;
            organizationalUnit.getContributors().add(new Contributor(oldOwner, ContributorType.OWNER));
            configGroup.removeConfigItem("owner");
        }
        if ((oldContributors = configGroup.getConfigItem("contributors")) != null) {
            shouldUpdateConfigGroup = true;
            for (String userName : (List)oldContributors.getValue()) {
                if (userName.equals(oldOwner)) continue;
                organizationalUnit.getContributors().add(new Contributor(userName, ContributorType.CONTRIBUTOR));
            }
            configGroup.removeConfigItem("contributors");
        }
        if (!shouldUpdateConfigGroup) {
            ConfigItem newContributorsConfigItem = configGroup.getConfigItem("space-contributors");
            ((List)newContributorsConfigItem.getValue()).forEach(c -> organizationalUnit.getContributors().add(c));
        } else {
            configGroup.setConfigItem(this.configurationFactory.newConfigItem("space-contributors", (Object)organizationalUnit.getContributors()));
            this.configurationService.updateConfiguration(configGroup);
        }
    }
}

