/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.GlobalExtractor;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.model.Global;
import org.drools.model.Variable;
import org.drools.modelcompiler.KiePackagesBuilder;

public class RuleContext {
    private final KiePackagesBuilder builder;
    private final KnowledgePackageImpl pkg;
    private final RuleImpl rule;
    private final Map<Variable, Declaration> queryDeclaration = new HashMap<Variable, Declaration>();
    private final Map<Variable, Declaration> innerDeclaration = new HashMap<Variable, Declaration>();
    private final Map<Variable, Accumulate> accumulateSource = new HashMap<Variable, Accumulate>();
    private final Map<Variable, Pattern> patterns = new HashMap<Variable, Pattern>();
    private int patternIndex = -1;
    private boolean needStreamMode = false;

    public RuleContext(KiePackagesBuilder builder, KnowledgePackageImpl pkg, RuleImpl rule) {
        this.builder = builder;
        this.pkg = pkg;
        this.rule = rule;
    }

    public Collection<InternalKnowledgePackage> getKnowledgePackages() {
        return this.builder.getKiePackages();
    }

    public KnowledgePackageImpl getPkg() {
        return this.pkg;
    }

    public RuleImpl getRule() {
        return this.rule;
    }

    int getNextPatternIndex() {
        return ++this.patternIndex;
    }

    void registerPattern(Variable variable, Pattern pattern) {
        this.patterns.put(variable, pattern);
    }

    Pattern getPattern(Variable variable) {
        return this.patterns.get(variable);
    }

    Declaration getDeclaration(Variable variable) {
        if (variable == null) {
            return null;
        }
        if (variable.isFact()) {
            Declaration declaration = this.innerDeclaration.get(variable);
            if (declaration == null) {
                declaration = this.queryDeclaration.get(variable);
            }
            if (declaration == null) {
                Pattern pattern = this.patterns.get(variable);
                declaration = pattern != null ? pattern.getDeclaration() : null;
            }
            return declaration;
        }
        Global global = (Global)variable;
        ObjectType objectType = this.builder.getObjectType((Variable)global);
        GlobalExtractor globalExtractor = new GlobalExtractor(global.getName(), objectType);
        return new Declaration(global.getName(), (InternalReadAccessor)globalExtractor, new Pattern(0, objectType));
    }

    Declaration getQueryDeclaration(Variable variable) {
        return this.queryDeclaration.get(variable);
    }

    void addQueryDeclaration(Variable variable, Declaration declaration) {
        this.queryDeclaration.put(variable, declaration);
    }

    void addInnerDeclaration(Variable variable, Declaration declaration) {
        this.innerDeclaration.put(variable, declaration);
    }

    void addAccumulateSource(Variable variable, Accumulate accumulate) {
        this.accumulateSource.put(variable, accumulate);
    }

    Accumulate getAccumulateSource(Variable variable) {
        return this.accumulateSource.get(variable);
    }

    public ClassLoader getClassLoader() {
        return this.builder.getClassLoader();
    }

    public boolean needsStreamMode() {
        return this.needStreamMode;
    }

    public void setNeedStreamMode() {
        this.needStreamMode = true;
    }

    public Map<String, Declaration> getDeclarations() {
        HashMap<String, Declaration> decls = new HashMap<String, Declaration>();
        this.innerDeclaration.forEach((var, decl) -> decls.put(var.getName(), (Declaration)decl));
        this.patterns.forEach((var, pattern) -> decls.put(var.getName(), pattern.getDeclaration()));
        return decls;
    }

    public Class<?> getDeclarationClass(String name) {
        for (Map.Entry<Variable, Declaration> entry : this.innerDeclaration.entrySet()) {
            if (!entry.getKey().getName().equals(name)) continue;
            return entry.getValue().getDeclarationClass();
        }
        for (Map.Entry<Variable, Declaration> entry : this.patterns.entrySet()) {
            if (!entry.getKey().getName().equals(name)) continue;
            return ((Pattern)entry.getValue()).getDeclaration().getDeclarationClass();
        }
        return null;
    }
}

