/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.accumulate;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.expression.PatternExpressionBuilder;
import org.drools.modelcompiler.builder.generator.visitor.ModelGeneratorVisitor;
import org.drools.modelcompiler.builder.generator.visitor.accumulate.AccumulateVisitor;

public class AccumulateVisitorPatternDSL
extends AccumulateVisitor {
    public AccumulateVisitorPatternDSL(ModelGeneratorVisitor modelGeneratorVisitor, RuleContext context, PackageModel packageModel) {
        super(context, modelGeneratorVisitor, packageModel);
        this.expressionBuilder = new PatternExpressionBuilder(context);
    }

    @Override
    protected MethodCallExpr buildBinding(String bindingName, Collection<String> usedDeclaration, Expression expression) {
        MethodCallExpr bindDSL = new MethodCallExpr(null, "bind");
        bindDSL.addArgument(this.context.getVar(bindingName));
        usedDeclaration.stream().map(d -> this.context.getVarExpr((String)d)).forEach(arg_0 -> ((MethodCallExpr)bindDSL).addArgument(arg_0));
        bindDSL.addArgument(this.buildConstraintExpression(expression, usedDeclaration));
        return bindDSL;
    }

    @Override
    protected void processNewBinding(Optional<AccumulateVisitor.NewBinding> optNewBinding) {
        optNewBinding.ifPresent(newBinding -> {
            Optional<String> patterBinding = newBinding.patternBinding;
            List<Expression> allExpressions = this.context.getExpressions();
            MethodCallExpr newBindingExpression = newBinding.bindExpression;
            if (patterBinding.isPresent()) {
                Optional<MethodCallExpr> optPattern = DrlxParseUtil.findPatternWithBinding(this.context, patterBinding.get(), allExpressions);
                optPattern.ifPresent(pattern -> this.addBindAsLastChainCall(newBindingExpression, (MethodCallExpr)pattern));
            } else {
                MethodCallExpr lastPattern = DrlxParseUtil.findLastPattern(allExpressions).orElseThrow(() -> new RuntimeException("Need the last pattern to add the binding"));
                MethodCallExpr replacedBinding = this.replaceBindingWithPatternBinding(newBindingExpression, lastPattern);
                this.addBindAsLastChainCall(replacedBinding, lastPattern);
            }
        });
    }

    private void addBindAsLastChainCall(MethodCallExpr newBindingExpression, MethodCallExpr pattern) {
        Optional optParent = pattern.getParentNode();
        newBindingExpression.setScope((Expression)pattern);
        optParent.ifPresent(parent -> parent.replace((Node)pattern, (Node)newBindingExpression));
    }

    private MethodCallExpr replaceBindingWithPatternBinding(MethodCallExpr bindExpression, MethodCallExpr lastPattern) {
        Expression bindingId = lastPattern.getArgument(0);
        bindExpression.findFirst(NameExpr.class, e -> e.equals((Object)bindingId)).ifPresent(name -> {
            bindExpression.remove((Node)name);
            LambdaExpr lambda = (LambdaExpr)bindExpression.getArgument(bindExpression.getArguments().size() - 1);
            if (lambda.getParameters().size() > 1) {
                String formalArg = DrlxParseUtil.fromVar(name.getNameAsString());
                for (Parameter param : lambda.getParameters()) {
                    if (!param.getNameAsString().equals(formalArg)) continue;
                    lambda.getParameters().remove((Node)param);
                    lambda.getParameters().add(0, (Node)param);
                    break;
                }
            }
        });
        return bindExpression;
    }

    @Override
    protected void postVisit() {
    }
}

