/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Object;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class WeakMap<KEY, VALUE> {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ConstructorIterableIterableTypeParameterArrayUnionType<KEY, VALUE> {
    @JsOverlay
    static ConstructorIterableIterableTypeParameterArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default KEY asKEY() {
      return Js.cast(this);
    }

    @JsOverlay
    default VALUE asVALUE() {
      return Js.cast(this);
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ConstructorIterableUnionType<KEY, VALUE> {
    @JsOverlay
    static ConstructorIterableUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ConstructorIterableIterableTypeParameterArrayUnionType<KEY, VALUE>[][]
        asConstructorIterableArrayArrayUnionTypeArrayArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default Iterable<ConstructorIterableIterableTypeParameterArrayUnionType[]> asIterable() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isConstructorIterableArrayArrayUnionTypeArrayArray() {
      return (Object) this instanceof Object[];
    }
  }

  public WeakMap() {}

  public WeakMap(ConstructorIterableIterableTypeParameterArrayUnionType<KEY, VALUE>[][] iterable) {}

  public WeakMap(ConstructorIterableUnionType<KEY, VALUE> iterable) {}

  public WeakMap(Iterable<ConstructorIterableIterableTypeParameterArrayUnionType[]> iterable) {}

  public native void clear();

  public native boolean delete(KEY p0);

  public native VALUE get(KEY p0);

  public native boolean has(KEY p0);

  public native WeakMap<KEY, VALUE> set(KEY p0, VALUE p1);
}
