/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.migration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.tools.ant.ExitException;
import org.assertj.core.api.Assertions;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.workbench.common.forms.data.modeller.model.DataObjectFormModel;
import org.kie.workbench.common.forms.fields.test.TestMetaDataEntryManager;
import org.kie.workbench.common.forms.jbpm.model.authoring.process.BusinessProcessFormModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryManager;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FieldSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormDefinitionSerializerImpl;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormModelSerializer;
import org.kie.workbench.common.migration.Main;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

public class MigrationToolTest {
    private static final File NIOGIT_DIR = Paths.get("target/niogit", new String[0]).toFile();
    private static final String GIT_SUFFIX = ".git";
    private static final String PROJECT_A1 = "projectA1";
    private static final String PROJECT_B1 = "projectB1";
    private static final String PROJECT_B2 = "projectB2";
    private static final String PROJECT_B3 = "projectB3";
    private static final String PROJECT_WITH_HISTORY_1 = "projectWithHistory1";
    private static final String PROJECT_WITH_HISTORY_2 = "projectWithHistory2";
    private static final String PROJECT_WITH_FORMS = "projectWithForms";
    private static final String SPACE_A = "spaceA";
    private static final String SPACE_B = "spaceB";
    private static final String SPACE_C = "spaceC";
    private static final String SPACE_SYSTEM = "system";
    private static final String SPACE_EXAMPLE = "example";
    private static final FormDefinitionSerializer FORM_SERIALIZER = new FormDefinitionSerializerImpl(new FieldSerializer(), new FormModelSerializer(), (MetaDataEntryManager)new TestMetaDataEntryManager());
    private static SecurityManager originalSecurityManager;

    @BeforeClass
    public static void runToolAndCloneProjectRepos() throws GitAPIException {
        originalSecurityManager = System.getSecurityManager();
        System.setSecurityManager(new NoExitSecurityManager());
        try {
            MigrationToolTest.runMigrationTool();
        }
        catch (ExitException e) {
            Assertions.assertThat((int)e.getStatus()).isEqualTo(0);
        }
        finally {
            System.setSecurityManager(originalSecurityManager);
        }
        MigrationToolTest.cloneAllProjectRepos();
    }

    @Test
    public void testNewProjectStructure() {
        Object[] actualSpaceDirs = NIOGIT_DIR.list();
        Assertions.assertThat((Object[])actualSpaceDirs).containsExactlyInAnyOrder((Object[])new String[]{SPACE_A, SPACE_B, SPACE_C, SPACE_EXAMPLE, SPACE_SYSTEM});
        Assertions.assertThat(MigrationToolTest.getProjectRepos(SPACE_SYSTEM)).containsExactlyInAnyOrder((Object[])new String[]{"metadata.git", "plugins.git", "datasets.git", "preferences.git", "system.git"});
        Assertions.assertThat(MigrationToolTest.getProjectRepos(SPACE_A)).containsExactly((Object[])new String[]{"projectA1.git"});
        Assertions.assertThat(MigrationToolTest.getProjectRepos(SPACE_B)).containsExactlyInAnyOrder((Object[])new String[]{"projectB1.git", "projectB2.git", "projectB3.git", "projectWithHistory1.git", "projectWithHistory2.git", "projectWithForms.git"});
        Assertions.assertThat(MigrationToolTest.getProjectRepos(SPACE_C)).isEmpty();
        this.checkProjectFiles(SPACE_A, PROJECT_A1);
        this.checkProjectFiles(SPACE_B, PROJECT_B1);
        this.checkProjectFiles(SPACE_B, PROJECT_B2);
        this.checkProjectFiles(SPACE_B, PROJECT_B3);
    }

    @Test
    public void testNewPomStructure() throws IOException, XmlPullParserException {
        File projectDir = MigrationToolTest.getProjectDir(SPACE_B, PROJECT_B2);
        File pom = new File(projectDir, "pom.xml");
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = reader.read((InputStream)new FileInputStream(pom));
        Assertions.assertThat((String)model.getVersion()).isEqualTo((Object)"1.2.3");
        Assertions.assertThat((List)model.getDependencies()).hasSize(6);
        Assertions.assertThat((List)model.getBuild().getPlugins()).hasSize(1);
        Assertions.assertThat((String)model.getPackaging()).isEqualTo((Object)"kjar");
    }

    @Test
    public void testProjectGitHistory() throws IOException, GitAPIException {
        boolean latestCommit = false;
        boolean previousCommit = true;
        String javaComment = "// ";
        String firstCommitMsg = "first";
        String thirdCommitMsg = "third";
        String fourthCommitMsg = "fourth";
        String fifthCommitMsg = "fifth";
        String drl1Location = "src/main/resources/bxms/projectwithhistory1/drlWithGitHistory1.drl";
        String drl2Location = "src/main/resources/bxms/projectwithhistory2/drlWithGitHistory2.drl";
        File projectWithHistory1 = MigrationToolTest.getProjectDir(SPACE_B, PROJECT_WITH_HISTORY_1);
        File projectWithHistory2 = MigrationToolTest.getProjectDir(SPACE_B, PROJECT_WITH_HISTORY_2);
        File drl1 = new File(projectWithHistory1, "src/main/resources/bxms/projectwithhistory1/drlWithGitHistory1.drl");
        File drl2 = new File(projectWithHistory2, "src/main/resources/bxms/projectwithhistory2/drlWithGitHistory2.drl");
        Git repoFirst = Git.open((File)projectWithHistory1);
        Git repoSecond = Git.open((File)projectWithHistory2);
        List<String> commitMessagesDrl1 = this.getDrlCommitMessages(repoFirst, "src/main/resources/bxms/projectwithhistory1/drlWithGitHistory1.drl");
        List<String> commitMessagesDrl2 = this.getDrlCommitMessages(repoSecond, "src/main/resources/bxms/projectwithhistory2/drlWithGitHistory2.drl");
        Assertions.assertThat(commitMessagesDrl1).hasSize(4);
        Assertions.assertThat(commitMessagesDrl2).hasSize(3);
        Assertions.assertThat((String)commitMessagesDrl1.get(0)).startsWith((CharSequence)"fifth");
        Assertions.assertThat((String)commitMessagesDrl1.get(1)).startsWith((CharSequence)"fourth");
        Assertions.assertThat((String)commitMessagesDrl2.get(0)).startsWith((CharSequence)"third");
        Assertions.assertThat((String)commitMessagesDrl2.get(1)).startsWith((CharSequence)"first");
        Assertions.assertThat((String)this.getDrlLineWithContent(drl1)).isEqualTo((Object)"// fifth");
        Assertions.assertThat((String)this.getDrlLineWithContent(drl2)).isEqualTo((Object)"// third");
        this.resetRepoToPreviousDrlCommit(repoFirst);
        this.resetRepoToPreviousDrlCommit(repoSecond);
        Assertions.assertThat((String)this.getDrlLineWithContent(drl1)).isEqualTo((Object)"// fourth");
        Assertions.assertThat((String)this.getDrlLineWithContent(drl2)).isEqualTo((Object)"// first");
    }

    @Test
    public void testTaskForm() throws IOException {
        FormDefinition taskFormDef = this.getFormFromResources("taskWithDifferentIO-taskform");
        this.checkFields(taskFormDef, (Map<String, List<String>>)new HashMap<String, List<String>>(){
            {
                this.put("boolean", Arrays.asList("_boolean (boolean)", "CheckBox", "_boolean"));
                this.put("cv", Arrays.asList("_cv (cv)", "Document", "_cv"));
                this.put("float", Arrays.asList("_float (float)", "DecimalBox", "_float"));
                this.put("integer", Arrays.asList("_integer (integer)", "IntegerBox", "_integer"));
                this.put("string", Arrays.asList("_string (string)", "TextBox", "_string"));
                this.put("person", Arrays.asList("person", "SubForm", "_person"));
            }
        });
        Assertions.assertThat((String)((TaskFormModel)taskFormDef.getModel()).getTaskName()).isEqualTo((Object)"taskWithDifferentIO");
    }

    @Test
    public void testPersonForm() throws IOException {
        FormDefinition personFormDef = this.getFormFromResources("PersonForm");
        LayoutTemplate layout = personFormDef.getLayoutTemplate();
        this.checkFields(personFormDef, (Map<String, List<String>>)new HashMap<String, List<String>>(){
            {
                this.put("person_address", Arrays.asList("address (person)", "SubForm", "address"));
                this.put("person_addressList", Arrays.asList("addressList (person)", "MultipleSubForm", "addressList"));
                this.put("person_age", Arrays.asList("age (person)", "IntegerBox", "age"));
                this.put("person_birthdate", Arrays.asList("birthdate (person)", "DatePicker", "birthdate"));
                this.put("person_married", Arrays.asList("married (person)", "CheckBox", "married"));
                this.put("person_name", Arrays.asList("name (person)", "TextBox", "name"));
                this.put("person_salary", Arrays.asList("salary (person)", "DecimalBox", "salary"));
                this.put("person_sex", Arrays.asList("sex (person)", "TextBox", "sex"));
            }
        });
        Assertions.assertThat((List)layout.getRows()).hasSize(4);
        Assertions.assertThat((List)((LayoutRow)layout.getRows().get(0)).getLayoutColumns()).hasSize(2);
        Assertions.assertThat((String)personFormDef.getFieldByName("person_salary").getHelpMessage()).isEqualTo((Object)"Please enter your salary in dollars.");
        Assertions.assertThat((Boolean)personFormDef.getFieldByName("person_birthdate").getRequired()).isTrue();
        Assertions.assertThat((Boolean)personFormDef.getFieldByName("person_married").getReadOnly()).isTrue();
        Assertions.assertThat((String)((DataObjectFormModel)personFormDef.getModel()).getType()).isEqualTo((Object)"bxms.projectWithForms.Person");
    }

    @Test
    public void testProcessForm() throws IOException {
        FormDefinition processFormDef = this.getFormFromResources("formmodeler-migration.UpdateUserProfile-taskform");
        this.checkFields(processFormDef, (Map<String, List<String>>)new HashMap<String, List<String>>(){
            {
                this.put("boolean", Arrays.asList("boolean (boolean)", "CheckBox", "boolean"));
                this.put("cv", Arrays.asList("cv (cv)", "Document", "cv"));
                this.put("float", Arrays.asList("float (float)", "DecimalBox", "float"));
                this.put("integer", Arrays.asList("integer (integer)", "IntegerBox", "integer"));
                this.put("string", Arrays.asList("string (string)", "TextBox", "string"));
                this.put("person", Arrays.asList("person", "SubForm", "person"));
            }
        });
        Assertions.assertThat((String)((BusinessProcessFormModel)processFormDef.getModel()).getProcessName()).isEqualTo((Object)"UpdateUserProfile");
    }

    @Test
    public void testHelperSubForms() throws IOException {
        File helperFormsDir = MigrationToolTest.getFile(SPACE_B, PROJECT_WITH_FORMS, "src/main/resources/bxms/projectWithForms/");
        List helperFormActualFields = this.getFormFromResources("taskWithSameIO-taskform-person").getFields().stream().map(FieldDefinition::getName).collect(Collectors.toList());
        Assertions.assertThat((Object[])helperFormsDir.list()).contains((Object[])new String[]{"formmodeler-migration.UpdateUserProfile-taskform-person.frm", "taskWithDifferentIO-taskform-person.frm", "taskWithSameIO-taskform-person.frm"});
        Assertions.assertThat(helperFormActualFields).containsExactlyInAnyOrder((Object[])new String[]{"person_address", "person_addressList", "person_birthdate", "person_married", "person_salary", "person_sex"});
    }

    private void checkProjectFiles(String spaceName, String projectName) {
        String assetId = projectName.substring(projectName.length() - 2);
        String projectNamePkg = projectName.toLowerCase();
        String assetIdResource = assetId.toLowerCase();
        String drlPath = String.format("/src/main/resources/bxms/%s/drl%s.drl", projectNamePkg, assetIdResource);
        String processPath = String.format("/src/main/resources/bxms/%s/process%s.bpmn2", projectNamePkg, assetIdResource);
        String dataObjectPath = String.format("/src/main/java/bxms/%s/Object%s.java", projectNamePkg, assetId);
        File drl = MigrationToolTest.getFile(spaceName, projectName, drlPath);
        File process = MigrationToolTest.getFile(spaceName, projectName, processPath);
        File dataObject = MigrationToolTest.getFile(spaceName, projectName, dataObjectPath);
        Assertions.assertThat((File)drl).exists();
        Assertions.assertThat((File)process).exists();
        Assertions.assertThat((File)dataObject).exists();
    }

    private void resetRepoToPreviousDrlCommit(Git projectRepo) throws GitAPIException {
        String previousDrlCommitRef = "HEAD~2";
        projectRepo.reset().setMode(ResetCommand.ResetType.HARD).setRef("HEAD~2").call();
    }

    private void checkFields(FormDefinition form, Map<String, List<String>> expectedFields) {
        Map<String, List> actualFields = form.getFields().stream().collect(Collectors.toMap(FieldDefinition::getName, f -> Arrays.asList(f.getLabel(), f.getFieldType().getTypeName(), f.getBinding())));
        Assertions.assertThat(actualFields).isEqualTo(expectedFields);
    }

    private List<String> getDrlCommitMessages(Git repo, String drlLocation) throws GitAPIException {
        Iterable projectCommits = repo.log().addPath(drlLocation).call();
        ArrayList<String> commitMessages = new ArrayList<String>();
        for (RevCommit c : projectCommits) {
            commitMessages.add(c.getFullMessage());
        }
        return commitMessages;
    }

    private String getDrlLineWithContent(File drlWithGitHistory) throws IOException {
        int lineWithContent = 2;
        return (String)FileUtils.readLines((File)drlWithGitHistory, (Charset)Charset.defaultCharset()).get(2);
    }

    private FormDefinition getFormFromResources(String formName) throws IOException {
        String formLocation = String.format("src/main/resources/bxms/%s/%s.frm", PROJECT_WITH_FORMS, formName);
        File form = MigrationToolTest.getFile(SPACE_B, PROJECT_WITH_FORMS, formLocation);
        String formContent = FileUtils.readFileToString((File)form, (Charset)Charset.defaultCharset());
        return FORM_SERIALIZER.deserialize(formContent);
    }

    private static void runMigrationTool() {
        String[] args = new String[]{"-b", "-t", NIOGIT_DIR.getAbsolutePath()};
        Main.main((String[])args);
    }

    private static void cloneAllProjectRepos() throws GitAPIException {
        MigrationToolTest.cloneProjectRepo(SPACE_A, PROJECT_A1);
        MigrationToolTest.cloneProjectRepo(SPACE_B, PROJECT_B1);
        MigrationToolTest.cloneProjectRepo(SPACE_B, PROJECT_B2);
        MigrationToolTest.cloneProjectRepo(SPACE_B, PROJECT_B3);
        MigrationToolTest.cloneProjectRepo(SPACE_B, PROJECT_WITH_FORMS);
        MigrationToolTest.cloneProjectRepo(SPACE_B, PROJECT_WITH_HISTORY_1);
        MigrationToolTest.cloneProjectRepo(SPACE_B, PROJECT_WITH_HISTORY_2);
    }

    private static void cloneProjectRepo(String spaceName, String projectName) throws GitAPIException {
        File projectDir = MigrationToolTest.getProjectDir(spaceName, projectName);
        String projectRepoDir = MigrationToolTest.getProjectRepoDir(spaceName, projectName).getAbsolutePath();
        Git.cloneRepository().setURI(projectRepoDir).setDirectory(projectDir).call();
    }

    private static List<String> getProjectRepos(String spaceName) {
        String[] spaceFiles = new File(NIOGIT_DIR, spaceName).list();
        return Arrays.stream(spaceFiles).filter(f -> f.endsWith(GIT_SUFFIX)).collect(Collectors.toList());
    }

    private static File getProjectRepoDir(String spaceName, String projectName) {
        File spaceDir = MigrationToolTest.getSpaceDir(spaceName);
        return new File(spaceDir, projectName + GIT_SUFFIX);
    }

    private static File getProjectDir(String spaceName, String projectName) {
        File spaceDir = MigrationToolTest.getSpaceDir(spaceName);
        return new File(spaceDir, projectName);
    }

    private static File getSpaceDir(String spaceName) {
        return new File(NIOGIT_DIR, spaceName);
    }

    private static File getFile(String spaceName, String projectName, String fileLocation) {
        File projectDir = MigrationToolTest.getProjectDir(spaceName, projectName);
        return new File(projectDir, fileLocation);
    }

    private static class NoExitSecurityManager
    extends SecurityManager {
        private NoExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkExit(int status) {
            super.checkExit(status);
            throw new ExitException(status);
        }
    }
}

