/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.config.AnnotationConfigurationImpl;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.AnnotationElement;

final class ConfigurationImpl
implements Configuration {
    private final boolean logOutOfSequenceReads;
    private final boolean logOutOfSequenceWrites;
    private final AnnotationsConfigImpl annotationsConfig;

    private ConfigurationImpl(boolean logOutOfSequenceReads, boolean logOutOfSequenceWrites, Map<String, AnnotationConfigurationImpl> annotations) {
        this.logOutOfSequenceReads = logOutOfSequenceReads;
        this.logOutOfSequenceWrites = logOutOfSequenceWrites;
        this.annotationsConfig = new AnnotationsConfigImpl(annotations);
    }

    @Override
    public boolean logOutOfSequenceReads() {
        return this.logOutOfSequenceReads;
    }

    @Override
    public boolean logOutOfSequenceWrites() {
        return this.logOutOfSequenceWrites;
    }

    @Override
    public Configuration.AnnotationsConfig annotationsConfig() {
        return this.annotationsConfig;
    }

    public String toString() {
        return "Configuration{logOutOfSequenceReads=" + this.logOutOfSequenceReads + ", logOutOfSequenceWrites=" + this.logOutOfSequenceWrites + ", annotationsConfig=" + this.annotationsConfig + '}';
    }

    static final class BuilderImpl
    implements Configuration.Builder {
        private boolean logOutOfSequenceReads = true;
        private boolean logOutOfSequenceWrites = true;
        private Configuration.AnnotationsConfig.Builder annotationsConfigBuilder = null;

        BuilderImpl() {
        }

        @Override
        public Configuration.Builder setLogOutOfSequenceReads(boolean logOutOfSequenceReads) {
            this.logOutOfSequenceReads = logOutOfSequenceReads;
            return this;
        }

        @Override
        public Configuration.Builder setLogOutOfSequenceWrites(boolean logOutOfSequenceWrites) {
            this.logOutOfSequenceWrites = logOutOfSequenceWrites;
            return this;
        }

        @Override
        public Configuration.AnnotationsConfig.Builder annotationsConfig() {
            if (this.annotationsConfigBuilder == null) {
                this.annotationsConfigBuilder = new AnnotationsConfigBuilderImpl();
            }
            return this.annotationsConfigBuilder;
        }

        @Override
        public Configuration build() {
            this.annotationsConfig().annotation("TypeId", AnnotationElement.AnnotationTarget.MESSAGE, AnnotationElement.AnnotationTarget.ENUM).attribute("value").type(AnnotationElement.AttributeType.INT).metadataCreator((annotatedDescriptor, annotation) -> annotation.getDefaultAttributeValue().getValue());
            AnnotationsConfigBuilderImpl annotationsConfig = (AnnotationsConfigBuilderImpl)this.annotationsConfig();
            HashMap<String, AnnotationConfigurationImpl> annotations = new HashMap<String, AnnotationConfigurationImpl>(annotationsConfig.annotationBuilders.size());
            for (AnnotationConfiguration.Builder annotationBuilder : annotationsConfig.annotationBuilders.values()) {
                AnnotationConfigurationImpl annotationConfig = ((AnnotationConfigurationImpl.BuilderImpl)annotationBuilder).buildAnnotationConfiguration();
                annotations.put(annotationConfig.name(), annotationConfig);
            }
            for (AnnotationConfigurationImpl a : annotations.values()) {
                String repeatable = a.repeatable();
                if (repeatable == null) continue;
                a.container = (AnnotationConfigurationImpl)annotations.get(repeatable);
            }
            return new ConfigurationImpl(this.logOutOfSequenceReads, this.logOutOfSequenceWrites, annotations);
        }

        private final class AnnotationsConfigBuilderImpl
        implements Configuration.AnnotationsConfig.Builder {
            private final Map<String, AnnotationConfiguration.Builder> annotationBuilders = new HashMap<String, AnnotationConfiguration.Builder>();

            private AnnotationsConfigBuilderImpl() {
            }

            @Override
            public AnnotationConfiguration.Builder annotation(String annotationName, AnnotationElement.AnnotationTarget ... target) {
                if (this.annotationBuilders.containsKey(annotationName)) {
                    throw new IllegalArgumentException("Duplicate annotation name definition: " + annotationName);
                }
                if (target == null || target.length == 0) {
                    throw new IllegalArgumentException("At least one target must be specified for annotation: " + annotationName);
                }
                AnnotationConfigurationImpl.BuilderImpl builder = new AnnotationConfigurationImpl.BuilderImpl(this, annotationName, target);
                this.annotationBuilders.put(annotationName, builder);
                return builder;
            }

            @Override
            public Configuration build() {
                return BuilderImpl.this.build();
            }
        }
    }

    private static final class AnnotationsConfigImpl
    implements Configuration.AnnotationsConfig {
        private final Map<String, AnnotationConfiguration> annotations;

        AnnotationsConfigImpl(Map<String, AnnotationConfigurationImpl> annotations) {
            this.annotations = Collections.unmodifiableMap(annotations);
        }

        @Override
        public Map<String, AnnotationConfiguration> annotations() {
            return this.annotations;
        }

        public String toString() {
            return "AnnotationsConfig{annotations=" + this.annotations + '}';
        }
    }
}

