/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.collect.Iterators;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.servlet.InstanceFilterBindingImpl;
import com.google.inject.servlet.LinkedFilterBindingImpl;
import com.google.inject.servlet.ServletModuleTargetVisitor;
import com.google.inject.servlet.ServletUtils;
import com.google.inject.servlet.UriPatternMatcher;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

class FilterDefinition
implements ProviderWithExtensionVisitor<FilterDefinition> {
    private final String pattern;
    private final Key<? extends Filter> filterKey;
    private final UriPatternMatcher patternMatcher;
    private final Map<String, String> initParams;
    private final Filter filterInstance;
    private final AtomicReference<Filter> filter = new AtomicReference();

    public FilterDefinition(String pattern, Key<? extends Filter> filterKey, UriPatternMatcher patternMatcher, Map<String, String> initParams, Filter filterInstance) {
        this.pattern = pattern;
        this.filterKey = filterKey;
        this.patternMatcher = patternMatcher;
        this.initParams = Collections.unmodifiableMap(new HashMap<String, String>(initParams));
        this.filterInstance = filterInstance;
    }

    public FilterDefinition get() {
        return this;
    }

    public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
        if (visitor instanceof ServletModuleTargetVisitor) {
            if (this.filterInstance != null) {
                return ((ServletModuleTargetVisitor)visitor).visit(new InstanceFilterBindingImpl(this.initParams, this.pattern, this.filterInstance, this.patternMatcher));
            }
            return ((ServletModuleTargetVisitor)visitor).visit(new LinkedFilterBindingImpl(this.initParams, this.pattern, this.filterKey, this.patternMatcher));
        }
        return (V)visitor.visit(binding);
    }

    private boolean shouldFilter(String uri) {
        return uri != null && this.patternMatcher.matches(uri);
    }

    public void init(final ServletContext servletContext, Injector injector, Set<Filter> initializedSoFar) throws ServletException {
        if (!Scopes.isSingleton((Binding)injector.getBinding(this.filterKey))) {
            String string = String.valueOf(String.valueOf(this.filterKey));
            throw new ServletException(new StringBuilder(71 + string.length()).append("Filters must be bound as singletons. ").append(string).append(" was not bound in singleton scope.").toString());
        }
        Filter filter = (Filter)injector.getInstance(this.filterKey);
        this.filter.set(filter);
        if (initializedSoFar.contains(filter)) {
            return;
        }
        filter.init(new FilterConfig(){

            public String getFilterName() {
                return FilterDefinition.this.filterKey.toString();
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public String getInitParameter(String s) {
                return (String)FilterDefinition.this.initParams.get(s);
            }

            public Enumeration getInitParameterNames() {
                return Iterators.asEnumeration(FilterDefinition.this.initParams.keySet().iterator());
            }
        });
        initializedSoFar.add(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Set<Filter> destroyedSoFar) {
        Filter reference = this.filter.get();
        if (null == reference || destroyedSoFar.contains(reference)) {
            return;
        }
        try {
            reference.destroy();
        }
        finally {
            destroyedSoFar.add(reference);
        }
    }

    public Filter getFilterIfMatching(HttpServletRequest request) {
        String path = ServletUtils.getContextRelativePath(request);
        if (this.shouldFilter(path)) {
            return this.filter.get();
        }
        return null;
    }

    Filter getFilter() {
        return this.filter.get();
    }
}

