/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.commons.validation.Preconditions;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.UpdateRemoteConfig;

public class Push {
    private final GitImpl git;
    private final CredentialsProvider credentialsProvider;
    private final Pair<String, String> remote;
    private final boolean force;
    private final Collection<RefSpec> refSpecs;

    public Push(Git git, CredentialsProvider credentialsProvider, Pair<String, String> remote, boolean force, Collection<RefSpec> refSpecs) {
        this.git = (GitImpl)Preconditions.checkInstanceOf((String)"git", (Object)git, GitImpl.class);
        this.credentialsProvider = credentialsProvider;
        this.remote = (Pair)PortablePreconditions.checkNotNull((String)"remote", remote);
        this.force = force;
        this.refSpecs = refSpecs;
    }

    public void execute() throws InvalidRemoteException {
        try {
            List<RefSpec> specs = new UpdateRemoteConfig(this.git, this.remote, this.refSpecs).execute();
            ((PushCommand)this.git._push().setCredentialsProvider(this.credentialsProvider)).setRefSpecs(specs).setRemote((String)this.remote.getK1()).setForce(this.force).setPushAll().call();
        }
        catch (InvalidRemoteException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

