/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.interceptor.CustomInterceptorMetadata;
import org.jboss.weld.interceptor.reader.InterceptorMetadataImpl;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.reader.PlainInterceptorFactory;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;

public class InterceptorMetadataReader {
    private final BeanManagerImpl manager;
    private final ComputingCache<Class<?>, InterceptorClassMetadata<?>> plainInterceptorMetadataCache;
    private final ComputingCache<Interceptor<?>, InterceptorClassMetadata<?>> cdiInterceptorMetadataCache;
    private final Function<Interceptor<?>, InterceptorClassMetadata<?>> interceptorToInterceptorMetadataFunction;

    public InterceptorMetadataReader(final BeanManagerImpl manager) {
        this.manager = manager;
        ComputingCacheBuilder cacheBuilder = ComputingCacheBuilder.newBuilder();
        this.plainInterceptorMetadataCache = cacheBuilder.build(new Function<Class<?>, InterceptorClassMetadata<?>>(){

            @Override
            public InterceptorClassMetadata<?> apply(Class<?> key) {
                EnhancedAnnotatedType<?> type = ((ClassTransformer)manager.getServices().get(ClassTransformer.class)).getEnhancedAnnotatedType(key, manager.getId());
                PlainInterceptorFactory<?> factory = PlainInterceptorFactory.of(key, manager);
                return new InterceptorMetadataImpl(key, factory, InterceptorMetadataUtils.buildMethodMap(type, false, manager));
            }
        });
        this.cdiInterceptorMetadataCache = cacheBuilder.build(new Function<Interceptor<?>, InterceptorClassMetadata<?>>(){

            @Override
            public InterceptorClassMetadata<?> apply(Interceptor<?> key) {
                return CustomInterceptorMetadata.of(key);
            }
        });
        this.interceptorToInterceptorMetadataFunction = new Function<Interceptor<?>, InterceptorClassMetadata<?>>(){

            @Override
            public InterceptorClassMetadata<?> apply(Interceptor<?> input) {
                return InterceptorMetadataReader.this.getCdiInterceptorMetadata(input);
            }
        };
    }

    public <T> InterceptorClassMetadata<T> getPlainInterceptorMetadata(Class<T> clazz) {
        return (InterceptorClassMetadata)this.plainInterceptorMetadataCache.getCastValue(clazz);
    }

    public <T> TargetClassInterceptorMetadata getTargetClassInterceptorMetadata(EnhancedAnnotatedType<T> type) {
        return TargetClassInterceptorMetadata.of(InterceptorMetadataUtils.buildMethodMap(type, true, this.manager));
    }

    public <T> InterceptorClassMetadata<T> getCdiInterceptorMetadata(Interceptor<T> interceptor) {
        if (interceptor instanceof InterceptorImpl) {
            InterceptorImpl interceptorImpl = (InterceptorImpl)interceptor;
            return interceptorImpl.getInterceptorMetadata();
        }
        return (InterceptorClassMetadata)this.cdiInterceptorMetadataCache.getCastValue(interceptor);
    }

    public Function<Interceptor<?>, InterceptorClassMetadata<?>> getInterceptorToInterceptorMetadataFunction() {
        return this.interceptorToInterceptorMetadataFunction;
    }

    public void cleanAfterBoot() {
        this.plainInterceptorMetadataCache.clear();
        this.cdiInterceptorMetadataCache.clear();
    }
}

