/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.whitelist;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.guvnor.common.services.project.model.POM;
import org.kie.workbench.common.services.backend.builder.core.NoBuilderFoundException;
import org.kie.workbench.common.services.backend.whitelist.PackageNameSearchProvider;
import org.kie.workbench.common.services.shared.whitelist.WhiteList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.support.SupportsRead;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class PackageNameWhiteListLoader
implements SupportsRead<WhiteList> {
    private static final Logger logger = LoggerFactory.getLogger(PackageNameWhiteListLoader.class);
    private PackageNameSearchProvider packageNameSearchProvider;
    private IOService ioService;

    public PackageNameWhiteListLoader() {
    }

    @Inject
    public PackageNameWhiteListLoader(PackageNameSearchProvider packageNameSearchProvider, @Named(value="ioStrategy") IOService ioService) {
        this.packageNameSearchProvider = packageNameSearchProvider;
        this.ioService = ioService;
    }

    public WhiteList load(org.uberfire.backend.vfs.Path packageNamesWhiteListPath) {
        return new WhiteList(this.parsePackages(this.loadContent(packageNamesWhiteListPath)));
    }

    protected String loadContent(org.uberfire.backend.vfs.Path packageNamesWhiteListPath) {
        Path path = Paths.convert((org.uberfire.backend.vfs.Path)packageNamesWhiteListPath);
        if (Files.exists((Path)path, (LinkOption[])new LinkOption[0])) {
            return this.ioService.readAllString(path);
        }
        return "";
    }

    private boolean isEmpty(String content) {
        return content == null || content.trim().isEmpty();
    }

    private List<String> parsePackages(String content) {
        if (this.isEmpty(content)) {
            return Collections.emptyList();
        }
        try {
            return IOUtils.readLines((Reader)new StringReader(content));
        }
        catch (IOException ioe) {
            logger.warn("Unable to parse package names from '" + content + "'. Falling back to empty list.");
            return Collections.emptyList();
        }
    }

    public WhiteList load(POM pom) {
        try {
            return new WhiteList(this.packageNameSearchProvider.newTopLevelPackageNamesSearch(pom).search());
        }
        catch (NoBuilderFoundException e) {
            logger.info("Could not create white list for project: " + pom.getGav().toString());
            return new WhiteList();
        }
    }
}

