/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.system.space.configuration;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.kie.workbench.common.project.cli.util.ConfigGroupToSpaceInfoConverter;

@ApplicationScoped
public class ConfigGroupsMigrationService {
    private ConfigurationService configurationService;
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    private ConfigGroupToSpaceInfoConverter configGroupToSpaceInfoConverter;

    ConfigGroupsMigrationService() {
    }

    @Inject
    public ConfigGroupsMigrationService(ConfigurationService configurationService, SpaceConfigStorageRegistry spaceConfigStorageRegistry, ConfigGroupToSpaceInfoConverter configGroupToSpaceInfoConverter) {
        this.configurationService = configurationService;
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
        this.configGroupToSpaceInfoConverter = configGroupToSpaceInfoConverter;
    }

    public void moveDataToSpaceConfigRepo() {
        List groups = this.configurationService.getConfiguration(ConfigType.SPACE);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                this.saveSpaceInfo(this.configGroupToSpaceInfoConverter.toSpaceInfo(groupConfig));
                this.configurationService.removeConfiguration(groupConfig);
                this.configGroupToSpaceInfoConverter.cleanUpRepositories(groupConfig);
            }
            this.configurationService.cleanUpSystemRepository();
        }
    }

    void saveSpaceInfo(SpaceInfo spaceInfo) {
        this.spaceConfigStorageRegistry.get(spaceInfo.getName()).saveSpaceInfo(spaceInfo);
    }
}

