/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.project.utils.NewWorkspaceProjectUtils;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitHookSupport;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

public class WorkspaceProjectServiceImpl
implements WorkspaceProjectService {
    private static final String GIT_SCHEME = "git";
    private static final String REMOTE_ORIGIN_REF = "refs/remotes/origin/master";
    private static final String ORIGIN_KEY = "origin";
    private OrganizationalUnitService organizationalUnitService;
    private RepositoryService repositoryService;
    private Event<NewProjectEvent> newProjectEvent;
    private Event<RepositoryUpdatedEvent> repositoryUpdatedEvent;
    private Event<NewBranchEvent> newBranchEvent;
    private ModuleService<? extends Module> moduleService;
    private SpacesAPI spaces;
    private ModuleRepositoryResolver repositoryResolver;
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    private Logger logger = LoggerFactory.getLogger(WorkspaceProjectServiceImpl.class);
    private IOService ioService;
    private PathUtil pathUtil;
    private ChangeRequestService changeRequestService;
    private POMService pomService;

    public WorkspaceProjectServiceImpl() {
    }

    @Inject
    public WorkspaceProjectServiceImpl(OrganizationalUnitService organizationalUnitService, RepositoryService repositoryService, SpacesAPI spaces, Event<NewProjectEvent> newProjectEvent, Event<RepositoryUpdatedEvent> repositoryUpdatedEvent, Event<NewBranchEvent> newBranchEvent, Instance<ModuleService<? extends Module>> moduleServices, ModuleRepositoryResolver repositoryResolver, @Named(value="ioStrategy") IOService ioService, SpaceConfigStorageRegistry spaceConfigStorageRegistry, PathUtil pathUtil, ChangeRequestService changeRequestService, POMService pomService) {
        this.organizationalUnitService = organizationalUnitService;
        this.repositoryService = repositoryService;
        this.spaces = spaces;
        this.newProjectEvent = newProjectEvent;
        this.repositoryUpdatedEvent = repositoryUpdatedEvent;
        this.newBranchEvent = newBranchEvent;
        this.moduleService = (ModuleService)moduleServices.get();
        this.repositoryResolver = repositoryResolver;
        this.ioService = ioService;
        this.pathUtil = pathUtil;
        this.changeRequestService = changeRequestService;
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
        this.pomService = pomService;
    }

    public Collection<WorkspaceProject> getAllWorkspaceProjects() {
        ArrayList<WorkspaceProject> result = new ArrayList<WorkspaceProject>();
        for (OrganizationalUnit ou : this.organizationalUnitService.getOrganizationalUnits()) {
            result.addAll(this.getAllWorkspaceProjects(ou));
        }
        return result;
    }

    public Collection<WorkspaceProject> getAllWorkspaceProjects(OrganizationalUnit organizationalUnit) {
        return this.getAllWorkspaceProjectsByName(organizationalUnit, null);
    }

    public Collection<WorkspaceProject> getAllWorkspaceProjectsByName(OrganizationalUnit organizationalUnit, String name) {
        return this.getAllWorkspaceProjectsByName(organizationalUnit, name, false);
    }

    public Collection<WorkspaceProject> getAllWorkspaceProjectsByName(OrganizationalUnit organizationalUnit, String name, boolean includeDeleted) {
        ArrayList<WorkspaceProject> result = new ArrayList<WorkspaceProject>();
        Space space = this.spaces.getSpace(organizationalUnit.getName());
        for (Repository repository : this.repositoryService.getAllRepositories(space, includeDeleted)) {
            if (!repository.getDefaultBranch().isPresent()) continue;
            WorkspaceProject project = new WorkspaceProject(organizationalUnit, repository, (Branch)repository.getDefaultBranch().get(), this.moduleService.resolveModule(((Branch)repository.getDefaultBranch().get()).getPath()));
            if (name != null && !name.equals(project.getName())) continue;
            result.add(project);
        }
        return result;
    }

    public boolean spaceHasNoProjectsWithName(OrganizationalUnit organizationalUnit, String name, WorkspaceProject projectToIgnore) {
        return this.getAllWorkspaceProjectsByName(organizationalUnit, name).stream().noneMatch(p -> !p.getEncodedIdentifier().equals(projectToIgnore.getEncodedIdentifier()));
    }

    public WorkspaceProject newProject(OrganizationalUnit organizationalUnit, POM pom) {
        return this.newProject(organizationalUnit, pom, DeploymentMode.VALIDATED);
    }

    public WorkspaceProject newProject(OrganizationalUnit organizationalUnit, POM pom, DeploymentMode mode) {
        return this.newProject(organizationalUnit, pom, mode, null);
    }

    public WorkspaceProject newProject(OrganizationalUnit organizationalUnit, POM pom, DeploymentMode mode, List<Contributor> contributors) {
        return this.newProject(organizationalUnit, pom, mode, contributors, null);
    }

    public WorkspaceProject newProject(OrganizationalUnit organizationalUnit, POM pom, DeploymentMode mode, List<Contributor> contributors, Repository templateRepository) {
        return this.newProject(organizationalUnit, pom, mode, contributors, templateRepository, null);
    }

    public WorkspaceProject newProject(OrganizationalUnit organizationalUnit, POM pom, DeploymentMode mode, List<Contributor> contributors, Repository templateRepository, String remoteRepositoryUrl) {
        return (WorkspaceProject)this.spaceConfigStorageRegistry.getBatch(organizationalUnit.getSpace().getName()).run(context -> {
            String newName = this.createFreshProjectName(organizationalUnit, pom.getName());
            pom.setName(newName);
            if (DeploymentMode.VALIDATED.equals((Object)mode)) {
                this.checkRepositories(pom);
            }
            String repositoryAlias = this.createFreshRepositoryAlias(organizationalUnit, pom.getName());
            boolean createFromTemplate = templateRepository != null;
            RepositoryEnvironmentConfigurations configurations = createFromTemplate ? this.createRepositoryConfigForTemplate(templateRepository) : new RepositoryEnvironmentConfigurations();
            Repository repository = this.repositoryService.createRepository(organizationalUnit, GIT_SCHEME, repositoryAlias, configurations, contributors != null ? contributors : Collections.emptyList());
            try {
                Module module;
                Branch defaultBranch = this.resolveDefaultBranch(repository);
                Module module2 = module = createFromTemplate ? this.finishCreateFromTemplate(repository, templateRepository, pom) : (Module)this.moduleService.newModule(defaultBranch.getPath(), pom, mode);
                if (remoteRepositoryUrl != null) {
                    this.addRemoteOrigin(repository, remoteRepositoryUrl);
                    this.executePostCommitHook(repository);
                }
                WorkspaceProject workspaceProject = new WorkspaceProject(organizationalUnit, repository, defaultBranch, module);
                this.newProjectEvent.fire((Object)new NewProjectEvent(workspaceProject));
                return workspaceProject;
            }
            catch (Exception e) {
                this.logger.error("Error trying to create project", (Throwable)e);
                this.logger.error("Error trying to create project " + organizationalUnit.getName() + " - " + repository.getAlias(), (Throwable)e);
                try {
                    this.repositoryService.removeRepository(this.spaces.getSpace(organizationalUnit.getName()), repository.getAlias());
                }
                catch (Exception ex) {
                    this.logger.error("Error trying to delete repository", (Throwable)ex);
                    this.logger.error("Error trying to delete repository " + organizationalUnit.getName() + " - " + repository.getAlias(), (Throwable)ex);
                    throw ExceptionUtilities.handleException((Exception)ex);
                }
                throw ExceptionUtilities.handleException((Exception)e);
            }
        });
    }

    private RepositoryEnvironmentConfigurations createRepositoryConfigForTemplate(Repository templateRepository) {
        RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
        File repositoryDirectory = this.resolveRepositoryDirectory(templateRepository);
        configurations.setInit(false);
        configurations.setOrigin(repositoryDirectory.toURI().toString());
        configurations.setMirror(false);
        return configurations;
    }

    private File resolveRepositoryDirectory(Repository repository) {
        Git git = this.resolveGit(repository);
        return git.getRepository().getDirectory();
    }

    private Branch resolveDefaultBranch(Repository repository) {
        return (Branch)repository.getDefaultBranch().orElseThrow(() -> new IllegalStateException("New repository should always have a branch."));
    }

    private Git resolveGit(Repository repository) {
        return this.resolveJGitFileSystem(repository).getGit();
    }

    private void executePostCommitHook(Repository repository) {
        JGitFileSystem fs = this.resolveJGitFileSystem(repository);
        ((GitHookSupport)fs.provider()).executePostCommitHook(fs);
    }

    private JGitFileSystem resolveJGitFileSystem(Repository repository) {
        Branch defaultBranch = this.resolveDefaultBranch(repository);
        return (JGitFileSystem)((JGitPathImpl)this.pathUtil.convert(defaultBranch.getPath())).getFileSystem();
    }

    private Module finishCreateFromTemplate(Repository projectRepository, Repository templateRepository, POM pom) {
        this.cleanUpTemplateOrigin(projectRepository);
        this.updateTemplatePOM(projectRepository, templateRepository, pom);
        Branch defaultBranch = this.resolveDefaultBranch(projectRepository);
        this.moduleService.createModuleDirectories(defaultBranch.getPath());
        return this.moduleService.resolveModule(Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)defaultBranch.getPath()).getRoot()));
    }

    private void cleanUpTemplateOrigin(Repository repository) {
        Git git = this.resolveGit(repository);
        git.removeRemote(ORIGIN_KEY, REMOTE_ORIGIN_REF);
    }

    private void addRemoteOrigin(Repository repository, String remoteRepositoryUrl) {
        Git git = this.resolveGit(repository);
        git.addRemote(ORIGIN_KEY, remoteRepositoryUrl);
    }

    private void updateTemplatePOM(Repository projectRepository, Repository templateRepository, POM pom) {
        org.uberfire.backend.vfs.Path repositoryRoot = this.resolveDefaultBranch(projectRepository).getPath();
        org.uberfire.backend.vfs.Path templatePath = this.resolveDefaultBranch(templateRepository).getPath();
        org.uberfire.backend.vfs.Path pomPath = this.resolvePathFromParent(repositoryRoot, "pom.xml");
        org.uberfire.backend.vfs.Path templatePomPath = this.resolvePathFromParent(templatePath, "pom.xml");
        POM templatePom = (POM)this.pomService.load(templatePomPath);
        templatePom.setName(pom.getName());
        templatePom.setDescription(pom.getDescription());
        templatePom.getGav().setGroupId(pom.getGav().getGroupId());
        templatePom.getGav().setArtifactId(pom.getGav().getArtifactId());
        templatePom.getGav().setVersion(pom.getGav().getVersion());
        this.pomService.save(pomPath, (Object)templatePom, null, "Updating the POM file");
    }

    org.uberfire.backend.vfs.Path resolvePathFromParent(org.uberfire.backend.vfs.Path parent, String toResolve) {
        return Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)parent).resolve(toResolve));
    }

    String createFreshRepositoryAlias(OrganizationalUnit organizationalUnit, String projectName) {
        int index = 0;
        String suffix = "";
        String repositoryAlias = (String)PortablePreconditions.checkNotNull((String)"project name in pom model", (Object)NewWorkspaceProjectUtils.sanitizeProjectName((String)projectName));
        while (this.repositoryService.getRepositoryFromSpace(organizationalUnit.getSpace(), repositoryAlias + suffix) != null) {
            suffix = "-" + ++index;
        }
        return repositoryAlias + suffix;
    }

    public String createFreshProjectName(OrganizationalUnit organizationalUnit, String name) {
        int index = 0;
        String suffix = "";
        while (!this.getAllWorkspaceProjectsByName(organizationalUnit, name + suffix, true).isEmpty()) {
            suffix = "-" + ++index;
        }
        return name + suffix;
    }

    public WorkspaceProject resolveProject(Repository repository) {
        if (!repository.getDefaultBranch().isPresent()) {
            throw new IllegalStateException("New repository should always have a branch.");
        }
        return this.resolveProject(repository.getSpace(), (Branch)repository.getDefaultBranch().get());
    }

    public WorkspaceProject resolveProject(Space space, Branch branch) {
        return this.resolveProject(space, branch.getPath());
    }

    public WorkspaceProject resolveProject(Space space, Module module) {
        return this.resolveProject(space, module.getRootPath());
    }

    public WorkspaceProject resolveProject(Space space, String name) {
        OrganizationalUnit ou = this.organizationalUnitService.getOrganizationalUnit(space.getName());
        return this.resolveProject(ou, name);
    }

    public WorkspaceProject resolveProject(Space space, String projectName, String branchName) {
        WorkspaceProject workspaceProject = this.resolveProject(space, projectName);
        if (workspaceProject == null) {
            throw new IllegalArgumentException("project " + projectName + " not found.");
        }
        if (branchName == null) {
            return workspaceProject;
        }
        for (Branch branch : workspaceProject.getRepository().getBranches()) {
            if (!branch.getName().equals(branchName)) continue;
            return this.resolveProject(space, branch);
        }
        throw new IllegalArgumentException("branch " + branchName + " not found.");
    }

    private WorkspaceProject resolveProject(OrganizationalUnit ou, String name) {
        for (WorkspaceProject workspaceProject : this.getAllWorkspaceProjects(ou)) {
            if (!workspaceProject.getName().equals(name)) continue;
            return workspaceProject;
        }
        return null;
    }

    public WorkspaceProject resolveProjectByRepositoryAlias(Space space, String repositoryAlias) {
        return this.resolveProject(this.repositoryService.getRepositoryFromSpace(space, repositoryAlias));
    }

    public WorkspaceProject resolveProject(Space space, org.uberfire.backend.vfs.Path path) {
        Path repositoryRoot = Paths.convert((org.uberfire.backend.vfs.Path)path).getRoot();
        Repository repository = this.repositoryService.getRepository(space, Paths.convert((Path)repositoryRoot));
        if (repository == null) {
            throw new RuntimeException("Repository not found inside space " + space.getName() + " with path " + path.toURI() + " (root path " + repositoryRoot.toUri() + ")");
        }
        Branch branch = this.resolveBranch(repositoryRoot, repository);
        return new WorkspaceProject(this.organizationalUnitService.getOrganizationalUnit(repository.getSpace().getName()), repository, branch, this.moduleService.resolveModule(Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)branch.getPath()).getRoot())));
    }

    public WorkspaceProject resolveProject(org.uberfire.backend.vfs.Path path) {
        return this.spaces.resolveSpace(path.toURI()).map(space -> this.resolveProject((Space)space, path)).orElseThrow(() -> new IllegalArgumentException("Could not determine space containing path: " + path));
    }

    private Branch resolveBranch(Path repositoryRoot, Repository repository) {
        if (!repository.getDefaultBranch().isPresent()) {
            throw new RuntimeException("Default branch not found in repository " + repository.getAlias() + " with path " + repositoryRoot.toUri());
        }
        Branch defaultBranch = (Branch)repository.getDefaultBranch().get();
        if (!Paths.convert((org.uberfire.backend.vfs.Path)defaultBranch.getPath()).equals(repositoryRoot)) {
            for (Branch branch : repository.getBranches()) {
                if (!Paths.convert((org.uberfire.backend.vfs.Path)branch.getPath()).equals(repositoryRoot)) continue;
                return branch;
            }
        }
        return defaultBranch;
    }

    private void checkRepositories(POM pom) {
        Set repositories = this.repositoryResolver.getRepositoriesResolvingArtifact(pom.getGav(), new MavenRepositoryMetadata[0]);
        if (repositories.size() > 0) {
            throw new GAVAlreadyExistsException(pom.getGav(), repositories);
        }
    }

    public void addBranch(String newBranchName, String baseBranchName, WorkspaceProject project, String userIdentifier) {
        Branch baseBranch = (Branch)project.getRepository().getBranch(baseBranchName).orElseThrow(() -> new IllegalStateException("The base branch [" + baseBranchName + "] does not exists"));
        Path baseBranchPath = this.pathUtil.convert(baseBranch.getPath());
        String newBranchPathURI = this.pathUtil.replaceBranch(newBranchName, baseBranch.getPath().toURI());
        try {
            Path newBranchPath = this.ioService.get(new URI(newBranchPathURI));
            baseBranchPath.getFileSystem().provider().copy(baseBranchPath, newBranchPath, new CopyOption[0]);
            BranchPermissions branchPermissions = this.spaceConfigStorageRegistry.get(project.getSpace().getName()).loadBranchPermissions(baseBranchName, project.getRepository().getIdentifier());
            this.spaceConfigStorageRegistry.get(project.getSpace().getName()).saveBranchPermissions(newBranchName, project.getRepository().getIdentifier(), branchPermissions);
            Repository repository = this.repositoryService.getRepositoryFromSpace(project.getSpace(), project.getRepository().getAlias());
            this.repositoryUpdatedEvent.fire((Object)new RepositoryUpdatedEvent(repository));
            this.newBranchEvent.fire((Object)new NewBranchEvent(repository, newBranchName, baseBranchName, userIdentifier));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBranch(String branchName, WorkspaceProject project, String userIdentifier) {
        Branch branch = (Branch)project.getRepository().getBranch(branchName).orElseThrow(() -> new IllegalStateException("The branch [" + branchName + "] does not exists"));
        try {
            this.ioService.startBatch(this.pathUtil.convert(branch.getPath()).getFileSystem());
            this.repositoryService.getRepositoryFromSpace(project.getSpace(), project.getRepository().getAlias()).getBranch(branch.getName()).ifPresent(updatedBranch -> {
                Path branchPath = this.pathUtil.convert(branch.getPath());
                this.ioService.delete(branchPath, new DeleteOption[0]);
                this.spaceConfigStorageRegistry.get(project.getSpace().getName()).deleteBranchPermissions(branch.getName(), project.getRepository().getIdentifier());
                this.changeRequestService.deleteChangeRequests(project.getSpace().getName(), project.getRepository().getAlias(), branch.getName(), userIdentifier);
                Repository repository = this.repositoryService.getRepositoryFromSpace(project.getSpace(), project.getRepository().getAlias());
                this.repositoryUpdatedEvent.fire((Object)new RepositoryUpdatedEvent(repository));
            });
        }
        finally {
            this.ioService.endBatch();
        }
    }
}

