/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi.workspace;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workspace.WorkspaceContext;

@ApplicationScoped
public class WorkspaceNameResolver {
    public static final String GLOBAL_WORKSPACE_NAME = "global";
    private BeanManager beanManager;

    public WorkspaceNameResolver() {
    }

    @Inject
    public WorkspaceNameResolver(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public String getWorkspaceName() {
        try {
            SessionInfo sessionInfo = this.getSessionInfo();
            return sessionInfo.getIdentity().getIdentifier();
        }
        catch (Exception e) {
            String name = WorkspaceContext.get();
            if (name == null || name.isEmpty()) {
                return GLOBAL_WORKSPACE_NAME;
            }
            return name;
        }
    }

    protected SessionInfo getSessionInfo() {
        Bean bean = (Bean)this.beanManager.getBeans(SessionInfo.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
        return (SessionInfo)this.beanManager.getReference(bean, SessionInfo.class, creationalContext);
    }
}

