/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.ala;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.pipeline.ConfigBasedPipeline;
import org.guvnor.ala.pipeline.ConfigExecutor;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.registry.PipelineRegistry;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildExecConfig;
import org.kie.workbench.common.services.backend.builder.ala.LocalProjectConfig;
import org.kie.workbench.common.services.backend.builder.ala.LocalSourceConfig;
import org.kie.workbench.common.services.backend.builder.ala.impl.LocalBuildConfigImpl;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;

@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class BuildPipelineInitializer {
    public static final String LOCAL_BUILD_PIPELINE = "local-build-pipeline";
    private PipelineRegistry pipelineRegistry;
    private Instance<ConfigExecutor> configExecutors;
    private PipelineExecutor executor;

    public BuildPipelineInitializer() {
    }

    @Inject
    public BuildPipelineInitializer(PipelineRegistry pipelineRegistry, Instance<ConfigExecutor> configExecutors) {
        this.pipelineRegistry = pipelineRegistry;
        this.configExecutors = configExecutors;
    }

    public BuildPipelineInitializer(PipelineRegistry pipelineRegistry, Collection<ConfigExecutor> configs) {
        this.pipelineRegistry = pipelineRegistry;
        this.initLocalBuildPipeline();
        this.initExecutor(configs);
    }

    @Produces
    @Named(value="buildPipelineExecutor")
    public PipelineExecutor getExecutor() {
        return this.executor;
    }

    @PostConstruct
    private void init() {
        this.initLocalBuildPipeline();
        this.initExecutor();
    }

    private void initLocalBuildPipeline() {
        ConfigBasedPipeline localBuildPipeline = PipelineFactory.newBuilder().addConfigStage("Local Source Config", (Config)new LocalSourceConfig(){}).addConfigStage("Local Project Config", (Config)new LocalProjectConfig(){}).addConfigStage("Local Build Config", (Config)new LocalBuildConfigImpl()).addConfigStage("Local Build Exec", (Config)new LocalBuildExecConfig(){}).buildAs(LOCAL_BUILD_PIPELINE);
        this.pipelineRegistry.registerPipeline((Pipeline)localBuildPipeline);
    }

    private void initExecutor() {
        ArrayList<ConfigExecutor> configs = new ArrayList<ConfigExecutor>();
        this.configExecutors.iterator().forEachRemaining(configs::add);
        this.initExecutor(configs);
    }

    private void initExecutor(Collection<ConfigExecutor> configs) {
        this.executor = new PipelineExecutor(configs);
    }
}

