/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.events;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.simulation.AggregatedSimulationEvent;
import org.jbpm.simulation.SimulationEvent;

public class GenericSimulationEvent
implements SimulationEvent {
    protected String processId;
    protected long processInstanceId;
    protected Map<String, Object> customMetrics = new ConcurrentHashMap<String, Object>();
    protected long startTime;
    protected long endTime;
    protected UUID uuid;
    protected String type;
    protected AggregatedSimulationEvent aggregatedEvent;
    protected boolean used;

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public AggregatedSimulationEvent getAggregatedEvent() {
        return this.aggregatedEvent;
    }

    public void setAggregatedEvent(AggregatedSimulationEvent aggregatedEvent) {
        this.aggregatedEvent = aggregatedEvent;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    public GenericSimulationEvent(String processId, long processInstanceId, long startTime, long endTime, String type) {
        this.processId = processId;
        this.processInstanceId = processInstanceId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.uuid = UUID.randomUUID();
        this.type = type;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    @Override
    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getMetric(String name) {
        Object metric = this.customMetrics.get(name);
        if (metric != null) {
            return metric.toString();
        }
        return null;
    }

    public void addCustomMetric(String name, Object value) {
        this.customMetrics.put(name, value);
    }

    public String toString() {
        return "GenericSimulationEvent[process=" + this.processId + ", instance=" + this.processInstanceId + ", uuid=" + this.uuid + "]";
    }
}

