/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.fs.jgit.util.Git;

public class UpdateRemoteConfig {
    private final Git git;
    private final Pair<String, String> remote;
    private final Collection<RefSpec> refSpecs;

    public UpdateRemoteConfig(Git git, Pair<String, String> remote, Collection<RefSpec> refSpecs) {
        this.git = git;
        this.remote = remote;
        this.refSpecs = refSpecs;
    }

    public List<RefSpec> execute() throws IOException, URISyntaxException {
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
        if (this.refSpecs == null || this.refSpecs.isEmpty()) {
            specs.add(new RefSpec("+refs/heads/*:refs/remotes/" + (String)this.remote.getK1() + "/*"));
            specs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
            specs.add(new RefSpec("+refs/notes/*:refs/notes/*"));
        } else {
            specs.addAll(this.refSpecs);
        }
        StoredConfig config = this.git.getRepository().getConfig();
        String url = config.getString("remote", (String)this.remote.getK1(), "url");
        if (url == null) {
            RemoteConfig remoteConfig = new RemoteConfig((Config)this.git.getRepository().getConfig(), (String)this.remote.getK1());
            remoteConfig.addURI(new URIish((String)this.remote.getK2()));
            specs.forEach(arg_0 -> ((RemoteConfig)remoteConfig).addFetchRefSpec(arg_0));
            remoteConfig.update((Config)this.git.getRepository().getConfig());
            this.git.getRepository().getConfig().save();
        }
        return specs;
    }
}

