/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.ProtectionDomain;
import org.powermock.core.classloader.ClassMarker;
import org.powermock.core.classloader.DeferSupportingClassLoader;
import org.powermock.core.classloader.MockClassLoaderConfiguration;
import org.powermock.core.transformers.ClassWrapper;
import org.powermock.core.transformers.ClassWrapperFactory;
import org.powermock.core.transformers.MockTransformerChain;
import org.powermock.core.transformers.javassist.support.JavaAssistClassWrapperFactory;
import org.powermock.core.transformers.support.DefaultMockTransformerChain;

public abstract class MockClassLoader
extends DeferSupportingClassLoader {
    public static final String MODIFY_ALL_CLASSES = "*";
    protected ClassMarker classMarker;
    protected ClassWrapperFactory classWrapperFactory;
    private MockTransformerChain mockTransformerChain;

    protected MockClassLoader(String[] classesToMock, String[] packagesToDefer) {
        this(new MockClassLoaderConfiguration(classesToMock, packagesToDefer), new JavaAssistClassWrapperFactory());
    }

    protected MockClassLoader(MockClassLoaderConfiguration configuration, ClassWrapperFactory classWrapperFactory) {
        super(MockClassLoader.class.getClassLoader(), configuration);
        this.classWrapperFactory = classWrapperFactory;
        this.mockTransformerChain = DefaultMockTransformerChain.newBuilder().build();
    }

    @Override
    protected Class<?> loadClassByThisClassLoader(String className) throws ClassFormatError, ClassNotFoundException {
        Class<?> deferClass = this.deferTo.loadClass(className);
        Class<?> loadedClass = this.getConfiguration().shouldMockClass(className) ? this.loadMockClass(className, deferClass.getProtectionDomain()) : this.loadUnmockedClass(className, deferClass.getProtectionDomain());
        return loadedClass;
    }

    public void setMockTransformerChain(MockTransformerChain mockTransformerChain) {
        this.mockTransformerChain = mockTransformerChain;
    }

    public MockTransformerChain getMockTransformerChain() {
        return this.mockTransformerChain;
    }

    protected Class<?> loadUnmockedClass(String name, ProtectionDomain protectionDomain) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        URL res = this.deferTo.getResource(path);
        if (res != null) {
            try {
                return this.defineClass(name, res, protectionDomain);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> defineClass(String name, URL url, ProtectionDomain protectionDomain) throws IOException {
        byte[] b = this.readClass(url);
        return this.defineClass(name, b, 0, b.length, protectionDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readClass(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        InputStream in = connection.getInputStream();
        ByteArrayOutputStream tmpOut = null;
        try {
            int len;
            int contentLength = connection.getContentLength();
            tmpOut = contentLength != -1 ? new ByteArrayOutputStream(contentLength) : new ByteArrayOutputStream(16384);
            byte[] buf = new byte[512];
            while ((len = in.read(buf)) != -1) {
                tmpOut.write(buf, 0, len);
            }
            byte[] byArray = tmpOut.toByteArray();
            return byArray;
        }
        finally {
            in.close();
            if (tmpOut != null) {
                tmpOut.close();
            }
        }
    }

    private Class<?> loadMockClass(String name, ProtectionDomain protectionDomain) throws ClassNotFoundException {
        byte[] clazz = this.defineAndTransformClass(name, protectionDomain);
        return this.defineClass(name, protectionDomain, clazz);
    }

    public Class<?> defineClass(String name, ProtectionDomain protectionDomain, byte[] clazz) {
        return this.defineClass(name, clazz, 0, clazz.length, protectionDomain);
    }

    protected <T> ClassWrapper<T> transformClass(ClassWrapper<T> wrappedType) throws Exception {
        wrappedType = this.mockTransformerChain.transform(wrappedType);
        if (this.classMarker != null) {
            this.classMarker.mark(wrappedType);
        }
        return wrappedType;
    }

    protected abstract byte[] defineAndTransformClass(String var1, ProtectionDomain var2) throws ClassNotFoundException;
}

