/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.shared.test;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.shared.test.Failure;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class TestResultMessage {
    private String identifier;
    private int runCount;
    private Long runTime;
    private List<Failure> failures = new ArrayList<Failure>();

    public TestResultMessage() {
    }

    public TestResultMessage(String identifier, int runCount, long runTime, List<Failure> failures) {
        this.identifier = identifier;
        this.runCount = runCount;
        this.runTime = runTime;
        this.failures = failures;
    }

    public boolean wasSuccessful() {
        return this.failures.isEmpty();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public List<String> getResultStrings() {
        ArrayList<String> result = new ArrayList<String>(3 + (this.failures == null ? 0 : this.failures.size()));
        result.add("RunCount: " + this.runCount);
        if (this.failures != null) {
            for (Failure failure : this.failures) {
                result.add("Failure: " + failure.getMessage());
            }
        }
        return result;
    }

    public String toString() {
        return "TestResultMessage{identifier=" + this.identifier + ", runCount=" + this.runCount + ", failures=" + this.failures + '}';
    }
}

