/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadException;
import org.uberfire.server.util.FileServletUtil;
import org.uberfire.util.URIUtil;

public class UploadUriProvider {
    private static final String PARAM_PATH = "path";
    private static final String PARAM_FOLDER = "folder";
    private static final String PARAM_FILENAME = "fileName";
    private static final String PARAM_UPDATE = "update";

    public static URI getTargetLocation(HttpServletRequest request) throws URISyntaxException, FileUploadException {
        if (request.getParameter(PARAM_PATH) != null) {
            String parameter = request.getParameter(PARAM_PATH);
            String decode = FileServletUtil.decodeFileNamePart(parameter);
            String str = FileServletUtil.encodeFileNamePart(decode);
            return new URI(str);
        }
        if (request.getParameter(PARAM_FOLDER) != null) {
            return new URI(request.getParameter(PARAM_FOLDER).replaceAll("\\s", "%20") + "/" + FileServletUtil.encodeFileName(URIUtil.decode((String)request.getParameter(PARAM_FILENAME))));
        }
        throw new FileUploadException("Path to file was invalid.");
    }

    public static boolean isUpdate(HttpServletRequest request) {
        return Boolean.parseBoolean(request.getParameter(PARAM_UPDATE));
    }
}

