/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesRangeQuery;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Query;

public class SortedNumericDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedNumericDocValuesField(String name, long value) {
        super(name, TYPE);
        this.fieldsData = value;
    }

    public static Query newRangeQuery(String field, long lowerValue, long upperValue) {
        return new SortedNumericDocValuesRangeQuery(field, lowerValue, upperValue){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field) throws IOException {
                FieldInfo info = reader.getFieldInfos().fieldInfo(field);
                if (info == null) {
                    return null;
                }
                return DocValues.getSortedNumeric(reader, field);
            }
        };
    }

    public static Query newExactQuery(String field, long value) {
        return SortedNumericDocValuesField.newRangeQuery(field, value, value);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

