/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.util;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.math.BigDecimal;

public class BigDecimalArgumentCoercion {
    public Expression coercedArgument(Class<?> argumentType, Class<?> actualType, Expression argument) {
        boolean argumentTypeIsBigDecimal = BigDecimal.class.isAssignableFrom(argumentType);
        if (this.isInteger(actualType) && argumentTypeIsBigDecimal) {
            return this.bigDecimalToPrimitive(argument, "intValue");
        }
        if (this.isLong(actualType) && argumentTypeIsBigDecimal) {
            return this.bigDecimalToPrimitive(argument, "longValue");
        }
        if (this.isShort(actualType) && argumentTypeIsBigDecimal) {
            return this.bigDecimalToPrimitive(argument, "shortValue");
        }
        if (this.isDouble(actualType) && argumentTypeIsBigDecimal) {
            return this.bigDecimalToPrimitive(argument, "doubleValue");
        }
        if (this.isFloat(actualType) && argumentTypeIsBigDecimal) {
            return this.bigDecimalToPrimitive(argument, "floatValue");
        }
        return argument;
    }

    private MethodCallExpr bigDecimalToPrimitive(Expression argumentExpression, String intValue) {
        return new MethodCallExpr(argumentExpression, intValue, NodeList.nodeList((Node[])new Expression[0]));
    }

    private boolean isInteger(Class<?> actualType) {
        return actualType == Integer.TYPE || actualType == Integer.class;
    }

    private boolean isLong(Class<?> actualType) {
        return actualType == Long.TYPE || actualType == Long.class;
    }

    private boolean isFloat(Class<?> actualType) {
        return actualType == Float.TYPE || actualType == Float.class;
    }

    private boolean isDouble(Class<?> actualType) {
        return actualType == Double.TYPE || actualType == Double.class;
    }

    private boolean isShort(Class<?> actualType) {
        return actualType == Short.TYPE || actualType == Short.class;
    }
}

