/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage;

public class CreateQueueMessage_V2
extends CreateQueueMessage {
    protected boolean autoCreated;
    private RoutingType routingType;
    private int maxConsumers;
    private boolean purgeOnNoConsumers;

    public CreateQueueMessage_V2(SimpleString address, SimpleString queueName, RoutingType routingType, SimpleString filterString, boolean durable, boolean temporary, int maxConsumers, boolean purgeOnNoConsumers, boolean autoCreated, boolean requiresResponse) {
        this();
        this.address = address;
        this.queueName = queueName;
        this.filterString = filterString;
        this.durable = durable;
        this.temporary = temporary;
        this.autoCreated = autoCreated;
        this.requiresResponse = requiresResponse;
        this.routingType = routingType;
        this.maxConsumers = maxConsumers;
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    public CreateQueueMessage_V2() {
        super((byte)-12);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(super.getParentString());
        buff.append(", autoCreated=" + this.autoCreated);
        buff.append(", routingType=" + this.routingType);
        buff.append(", maxConsumers=" + this.maxConsumers);
        buff.append(", purgeOnNoConsumers=" + this.purgeOnNoConsumers);
        buff.append("]");
        return buff.toString();
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
    }

    public int getMaxConsumers() {
        return this.maxConsumers;
    }

    public void setMaxConsumers(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    public void setPurgeOnNoConsumers(boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public void setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeBoolean(this.autoCreated);
        buffer.writeByte(this.routingType == null ? (byte)-1 : this.routingType.getType());
        buffer.writeInt(this.maxConsumers);
        buffer.writeBoolean(this.purgeOnNoConsumers);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.autoCreated = buffer.readBoolean();
        this.routingType = RoutingType.getType((byte)buffer.readByte());
        this.maxConsumers = buffer.readInt();
        this.purgeOnNoConsumers = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.autoCreated ? 1231 : 1237);
        result = 31 * result + this.routingType.getType();
        result = 31 * result + this.maxConsumers;
        result = 31 * result + (this.purgeOnNoConsumers ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateQueueMessage_V2)) {
            return false;
        }
        CreateQueueMessage_V2 other = (CreateQueueMessage_V2)obj;
        if (this.autoCreated != other.autoCreated) {
            return false;
        }
        if (this.maxConsumers != other.maxConsumers) {
            return false;
        }
        if (this.purgeOnNoConsumers != other.purgeOnNoConsumers) {
            return false;
        }
        if (this.purgeOnNoConsumers != other.purgeOnNoConsumers) {
            return false;
        }
        return !(this.routingType == null ? other.routingType != null : !this.routingType.equals((Object)other.routingType));
    }
}

