/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import org.guvnor.common.services.project.model.Module;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.data.Cacheable;
import org.uberfire.spaces.Space;
import org.uberfire.util.URIUtil;

@Portable
public class WorkspaceProject
implements Cacheable {
    private Repository repository;
    private Branch branch;
    private Module mainModule;
    private OrganizationalUnit organizationalUnit;
    private boolean requiresRefresh = true;

    public WorkspaceProject() {
    }

    public WorkspaceProject(OrganizationalUnit organizationalUnit, Repository repository, Branch branch, Module mainModule) {
        this.organizationalUnit = (OrganizationalUnit)PortablePreconditions.checkNotNull((String)"organizationalUnit", (Object)organizationalUnit);
        this.repository = (Repository)PortablePreconditions.checkNotNull((String)"repository", (Object)repository);
        this.branch = (Branch)PortablePreconditions.checkNotNull((String)"branch", (Object)branch);
        this.mainModule = mainModule;
    }

    public OrganizationalUnit getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public Module getMainModule() {
        return this.mainModule;
    }

    public String getEncodedIdentifier() {
        return URIUtil.encodeQueryString((String)this.repository.getIdentifier());
    }

    public boolean requiresRefresh() {
        return this.requiresRefresh;
    }

    public String getName() {
        if (this.mainModule != null) {
            String moduleName = this.mainModule.getModuleName();
            if (moduleName != null && !this.mainModule.getModuleName().trim().isEmpty()) {
                return this.mainModule.getModuleName();
            }
            return this.repository.getAlias();
        }
        return this.repository.getAlias();
    }

    public void markAsCached() {
        this.requiresRefresh = false;
    }

    public Path getRootPath() {
        return this.getBranch().getPath();
    }

    public Space getSpace() {
        return this.getRepository().getSpace();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceProject workspaceProject = (WorkspaceProject)o;
        if (this.requiresRefresh != workspaceProject.requiresRefresh) {
            return false;
        }
        if (!this.repository.equals(workspaceProject.repository)) {
            return false;
        }
        if (!this.branch.equals((Object)workspaceProject.branch)) {
            return false;
        }
        if (this.mainModule != null ? !this.mainModule.equals(workspaceProject.mainModule) : workspaceProject.mainModule != null) {
            return false;
        }
        return this.organizationalUnit.equals(workspaceProject.organizationalUnit);
    }

    public int hashCode() {
        int result = ~(~this.repository.hashCode());
        result = 31 * result + ~(~this.branch.hashCode());
        result = 31 * result + (this.mainModule != null ? ~(~this.mainModule.hashCode()) : 0);
        result = 31 * result + ~(~this.organizationalUnit.hashCode());
        result = 31 * result + (this.requiresRefresh ? 1 : 0);
        return result;
    }
}

