/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextArea;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.views.pfly.widgets.ErrorPopup;
import org.uberfire.client.views.pfly.widgets.InlineNotification;
import org.uberfire.client.views.pfly.widgets.Modal;

@Dependent
@Templated
public class ErrorPopupView
implements IsElement,
ErrorPopup.View {
    private static final String DETAIL_COLLAPSED_ICON = "fa-angle-right";
    private static final String DETAIL_EXPANDED_ICON = "fa-angle-down";
    private static final String IN = "in";
    @Inject
    @DataField(value="message-container")
    private Div messageContainer;
    @Inject
    @DataField(value="inline-notification")
    private InlineNotification inlineNotification;
    @Inject
    @DataField(value="standard-notification")
    private Span standardNotification;
    @Inject
    @DataField(value="detail-container")
    private Div detailContainer;
    @Inject
    @DataField(value="detail-area")
    private TextArea detailArea;
    @Inject
    @DataField(value="detail-area-container")
    private Div detailAreaContainer;
    @Inject
    @DataField(value="detail-anchor-icon")
    private Span detailAnchorIcon;
    @Inject
    @DataField(value="detail-anchor")
    private Anchor detailAnchor;
    @Inject
    @DataField(value="modal")
    private Modal modal;
    @Inject
    private TranslationService translationService;
    private ErrorPopup presenter;

    @PostConstruct
    public void init() {
        this.inlineNotification.setType(InlineNotification.InlineNotificationType.DANGER);
    }

    public void init(ErrorPopup presenter) {
        this.presenter = presenter;
    }

    @Override
    public HTMLElement getInlineNotification() {
        return this.inlineNotification.getElement();
    }

    @Override
    public HTMLElement getStandardNotification() {
        return this.standardNotification;
    }

    @Override
    public void setInlineNotificationValue(String message) {
        this.inlineNotification.setMessage(message);
    }

    @Override
    public void setStandardNotificationValue(String message) {
        this.standardNotification.setTextContent(message);
    }

    @Override
    public void setNotification(HTMLElement notification) {
        DOMUtil.removeAllChildren((Node)this.messageContainer);
        this.messageContainer.appendChild((Node)notification);
    }

    @Override
    public void showDetailPanel(boolean show) {
        if (!show) {
            this.detailContainer.getStyle().setProperty("display", "none");
        } else {
            this.detailContainer.getStyle().removeProperty("display");
        }
    }

    @Override
    public void setDetailValue(String detail) {
        this.detailArea.setValue(detail);
    }

    @Override
    public boolean isDetailCollapsed() {
        return DOMUtil.hasCSSClass((HTMLElement)this.detailAnchorIcon, (String)DETAIL_COLLAPSED_ICON);
    }

    @Override
    public void setCollapseDetailIcon(boolean collapsed) {
        DOMUtil.removeCSSClass((HTMLElement)this.detailAnchorIcon, (String)DETAIL_COLLAPSED_ICON);
        DOMUtil.removeCSSClass((HTMLElement)this.detailAnchorIcon, (String)DETAIL_EXPANDED_ICON);
        if (collapsed) {
            DOMUtil.addCSSClass((HTMLElement)this.detailAnchorIcon, (String)DETAIL_COLLAPSED_ICON);
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.detailAnchorIcon, (String)DETAIL_EXPANDED_ICON);
        }
    }

    @Override
    public void setCollapseDetailPanel(boolean collapsed) {
        DOMUtil.removeCSSClass((HTMLElement)this.detailAreaContainer, (String)IN);
        if (!collapsed) {
            DOMUtil.addCSSClass((HTMLElement)this.detailAreaContainer, (String)IN);
        }
    }

    @Override
    public void setDetailLabel(String label) {
        this.detailAnchor.setTextContent(label);
    }

    @Override
    public String getShowDetailLabel() {
        return this.translationService.getTranslation("ErrorPopupView.ShowDetailLabel");
    }

    @Override
    public String getCloseDetailLabel() {
        return this.translationService.getTranslation("ErrorPopupView.CloseDetailLabel");
    }

    @Override
    public void show() {
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @EventHandler(value={"ok-button"})
    private void onOkClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.presenter.onOk();
    }

    @EventHandler(value={"close-button"})
    private void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.presenter.onClose();
    }

    @EventHandler(value={"detail-anchor"})
    private void onDetailClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.presenter.onDetail();
    }
}

