/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.compiler.compiler.BaseKnowledgeBuilderResultImpl;
import org.drools.compiler.compiler.DroolsError;

public class SerializableDroolsError
extends DroolsError
implements Externalizable {
    private String message;
    private int[] errorLines;
    private String errorClassName;
    private String namespace;

    public SerializableDroolsError() {
    }

    public SerializableDroolsError(BaseKnowledgeBuilderResultImpl error) {
        this.message = error.getMessage();
        this.errorLines = error.getLines();
        this.errorClassName = error.getClass().getName();
        this.namespace = error instanceof DroolsError ? ((DroolsError)error).getNamespace() : "";
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int[] getLines() {
        return this.errorLines;
    }

    @Override
    public String toString() {
        return this.errorClassName + ": " + this.getMessage();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.message);
        out.writeObject(this.errorLines);
        out.writeObject(this.errorClassName);
        out.writeObject(this.namespace);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.message = (String)in.readObject();
        this.errorLines = (int[])in.readObject();
        this.errorClassName = (String)in.readObject();
        this.namespace = (String)in.readObject();
    }
}

